% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_dynamics.R
\name{resource_semichemostat}
\alias{resource_semichemostat}
\title{Project resource using semichemostat model}
\usage{
resource_semichemostat(
  params,
  n,
  n_pp,
  n_other,
  rates,
  t,
  dt,
  resource_rate,
  resource_capacity,
  ...
)
}
\arguments{
\item{params}{A \link{MizerParams} object}

\item{n}{A matrix of species abundances (species x size)}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list with the abundances of other components}

\item{rates}{A list of rates as returned by \code{\link[=mizerRates]{mizerRates()}}}

\item{t}{The current time}

\item{dt}{Time step}

\item{resource_rate}{Resource replenishment rate}

\item{resource_capacity}{Resource carrying capacity}

\item{...}{Unused}
}
\value{
Vector containing resource spectrum at next timestep
}
\description{
This function calculates the resource abundance at time \code{t + dt} from all
abundances and rates at time \code{t}.
}
\details{
The time evolution of the resource spectrum is described by a
semi-chemostat equation
\deqn{\frac{\partial N_R(w,t)}{\partial t} = r_R(w) \Big[ c_R (w) - N_R(w,t) \Big] - \mu_R(w, t) N_R(w,t)}{dN_R(w,t)/d t  = r_R(w) ( c_R (w) - N_R(w,t) ) - \mu_R(w,t ) N_R(w,t)}

Here \eqn{r_R(w)} is the resource regeneration rate and \eqn{c_R(w)} is the
carrying capacity in the absence of predation. These parameters are changed
with \code{\link[=setResource]{setResource()}}. The mortality \eqn{\mu_R(w, t)} is
due to predation by consumers and is calculate with \code{\link[=getResourceMort]{getResourceMort()}}.

This function uses the analytic solution of the above equation, keeping the
mortality fixed during the timestep.

It is also possible to implement other resource dynamics, as
described in the help page for \code{\link[=setResource]{setResource()}}.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, NS_interaction,
                                resource_dynamics = "resource_semichemostat")
}
}
\seealso{
Other resource dynamics: 
\code{\link{resource_constant}()}
}
\concept{resource dynamics}
