% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimator.R
\docType{data}
\name{mlapiEstimation}
\alias{mlapiEstimation}
\title{Base abstract class for all classification/regression models}
\format{\code{R6Class} object.}
\usage{
mlapiEstimation
}
\description{
Base class for all estimators.
Defines minimal set of members and methods(with signatires) which have to be implemented in child classes.
}
\section{Methods}{

\describe{
  \item{\code{$fit(x, y, ...)}}{}
  \item{\code{$predict(x, ...)}}{Makes predictions on new data (after model was trained)}
}
}

\section{Arguments}{

\describe{
 \item{x}{A matrix like object, should \bold{inherit from \code{Matrix} or \code{matrix}}.
 Allowed classes should be defined in child classes.}
 \item{y}{target - usually \code{vector}, but also can be a matrix like object.
 Allowed classes should be defined in child classes.}
 \item{...}{additional parameters \bold{with default values}}
}
}

\examples{
SimpleLinearModel = R6::R6Class(
classname = "mlapiSimpleLinearModel",
inherit = mlapi::mlapiEstimation,
public = list(
  initialize = function(tol = 1e-7) {
    private$tol = tol
    super$set_internal_matrix_formats(dense = "matrix", sparse = NULL)
  },
  fit = function(x, y, ...) {
    x = super$check_convert_input(x)
   stopifnot(is.vector(y))
   stopifnot(is.numeric(y))
   stopifnot(nrow(x) == length(y))

   private$n_features = ncol(x)
   private$coefficients = .lm.fit(x, y, tol = private$tol)[["coefficients"]]
 },
 predict = function(x) {
   stopifnot(ncol(x) == private$n_features)
   x \%*\% matrix(private$coefficients, ncol = 1)
 }
),
private = list(
  tol = NULL,
  coefficients = NULL,
  n_features = NULL
))
set.seed(1)
model = SimpleLinearModel$new()
x = matrix(sample(100 * 10, replace = TRUE), ncol = 10)
y = sample(c(0, 1), 100, replace = TRUE)
model$fit(as.data.frame(x), y)
res1 = model$predict(x)
# check pipe-compatible S3 interface
res2 = predict(x, model)
identical(res1, res2)
}
\keyword{datasets}
