% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_dtw_1.R
\encoding{UTF-8}
\name{dis_dtw_1}
\alias{dis_dtw_1}
\title{Constructs a pairwise distance matrix based on multivariate
dynamic time warping}
\usage{
dis_dtw_1(X, normalization = FALSE, ...)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{normalization}{Logical. If \code{normalization = TRUE} (default), the normalized
distance is computed. Otherwise (default), no normalization is taken into account}

\item{...}{Additional parameters for the function. See  \code{\link[dtw]{dtw}}.}
}
\value{
The computed pairwise distance matrix.
}
\description{
\code{dis_dtw_1} returns a pairwise distance matrix based on one of the multivariate
extensions of the well-known dynamic time warping distance \insertCite{shokoohi2017generalizing}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS is defined as the sum of the standard
dynamic time warping distances between each corresponding pair of dimensions (univariate
time series)
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 5] # Selecting the first 5 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_dtw_1(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_dtw_1 without normalization
distance_matrix_normalized <- dis_dtw_1(toy_dataset, normalization = TRUE)
# Computing the pairwise distance matrix based
# on the distance dis_dtw_1 with normalization
}
\references{
{

  \insertRef{shokoohi2017generalizing}{mlmts}

}
}
\seealso{
\code{\link{dis_dtw_2}}, \code{\link{dis_mahalanobis_dtw}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
