% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radical.R
\name{radical}
\alias{radical}
\title{RADICAL}
\usage{
radical(
  input,
  angles = NA,
  noise_std_dev = NA,
  objective = FALSE,
  replicates = NA,
  seed = NA,
  sweeps = NA,
  verbose = getOption("mlpack.verbose", FALSE)
)
}
\arguments{
\item{input}{Input dataset for ICA (numeric matrix).}

\item{angles}{Number of angles to consider in brute-force search during
Radical2D.  Default value "150" (integer).}

\item{noise_std_dev}{Standard deviation of Gaussian noise.  Default
value "0.175" (numeric).}

\item{objective}{If set, an estimate of the final objective function is
printed.  Default value "FALSE" (logical).}

\item{replicates}{Number of Gaussian-perturbed replicates to use (per
point) in Radical2D.  Default value "30" (integer).}

\item{seed}{Random seed.  If 0, 'std::time(NULL)' is used.  Default
value "0" (integer).}

\item{sweeps}{Number of sweeps; each sweep calls Radical2D once for each
pair of dimensions.  Default value "0" (integer).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value
"getOption("mlpack.verbose", FALSE)" (logical).}
}
\value{
A list with several components:
\item{output_ic}{Matrix to save independent components to (numeric
  matrix).}
\item{output_unmixing}{Matrix to save unmixing matrix to (numeric
  matrix).}
}
\description{
An implementation of RADICAL, a method for independent component analysis
(ICA).  Given a dataset, this can decompose the dataset into an unmixing
matrix and an independent component matrix; this can be useful for
preprocessing.
}
\details{
An implementation of RADICAL, a method for independent component analysis
(ICA).  Assuming that we have an input matrix X, the goal is to find a square
unmixing matrix W such that Y = W * X and the dimensions of Y are independent
components.  If the algorithm is running particularly slowly, try reducing
the number of replicates.

The input matrix to perform ICA on should be specified with the "input"
parameter.  The output matrix Y may be saved with the "output_ic" output
parameter, and the output unmixing matrix W may be saved with the
"output_unmixing" output parameter.
}
\examples{
# For example, to perform ICA on the matrix "X" with 40 replicates, saving
# the independent components to "ic", the following command may be used: 

\dontrun{
output <- radical(input=X, replicates=40)
ic <- output$output_ic
}
}
\author{
mlpack developers
}
