# check this:
# - tune algo exists
# - parameters are not empty
# - algo can handle these parameters
# - algo can handle dependencies

checkTunerParset = function(learner, par.set, control) {
  cl = getClass1(control)

  if (getParamNr(par.set) == 0L)
    stop("No parameters were passed!")

  x = setdiff(names(par.set$pars), names(getParamSet(learner)$pars))
  if (length(x) > 0L)
    stopf("Can only tune parameters for which learner parameters exist: %s", collapse(x))

  checkParsOk = function(algo, ok)
    if (length(filterParams(par.set, type = ok)$pars) < length(par.set$pars))
      stopf("%s can only be applied to: %s!", algo, collapse(ok))

  checkStart = function() {
    if (!is.null(control$start)) {
      if (length(control$start) != length(par.set$pars))
        stop("Length of 'start' has to match number of parameters in 'par.set'!")
      x = setdiff(names(control$start), names(getParamSet(learner)$pars))
      if (length(x))
        stopf("'start' contains parameters for which no learner parameters exist: %s", collapse(x))
    }
  }

  # check special conditions for some tuners
  if (inherits(control, "TuneControlCMAES")) {
    checkParsOk("CMAES", c("numeric", "integer", "numericvector", "integervector"))
    checkStart()
  }

  # check requires / dependent params
  if (hasRequires(par.set) && cl %nin% c("TuneControlRandom", "TuneControlGrid",
      "TuneControlIrace", "TuneControlMBO"))
    stopf("Tuning algorithm for '%s' cannot handle dependent parameters!")
}
