% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuneWrapper.R
\name{makeTuneWrapper}
\alias{makeTuneWrapper}
\title{Fuse learner with tuning.}
\usage{
makeTuneWrapper(
  learner,
  resampling,
  measures,
  par.set,
  control,
  show.info = getMlrOption("show.info")
)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{resampling}{(\link{ResampleInstance} | \link{ResampleDesc})\cr
Resampling strategy to evaluate points in hyperparameter space. If you pass a description,
it is instantiated once at the beginning by default, so all points are
evaluated on the same training/test sets.
If you want to change that behavior, look at \link{TuneControl}.}

\item{measures}{(list of \link{Measure} | \link{Measure})\cr
Performance measures to evaluate. The first measure, aggregated by the first aggregation function
is optimized, others are simply evaluated.
Default is the default measure for the task, see here \link{getDefaultMeasure}.}

\item{par.set}{(\link[ParamHelpers:ParamSet]{ParamHelpers::ParamSet})\cr
Collection of parameters and their constraints for optimization.
Dependent parameters with a \code{requires} field must use \code{quote} and not
\code{expression} to define it.}

\item{control}{(\link{TuneControl})\cr
Control object for search method. Also selects the optimization algorithm for tuning.}

\item{show.info}{(\code{logical(1)})\cr
Print verbose output on console?
Default is set via \link{configureMlr}.}
}
\value{
\link{Learner}.
}
\description{
Fuses a base learner with a search strategy to select its hyperparameters.
Creates a learner object, which can be used like any other learner object,
but which internally uses \link{tuneParams}.
If the train function is called on it,
the search strategy and resampling are invoked
to select an optimal set of hyperparameter values. Finally, a model is fitted on the
complete training data with these optimal hyperparameters and returned.
See \link{tuneParams} for more details.

After training, the optimal hyperparameters (and other related information) can be retrieved with
\link{getTuneResult}.
}
\examples{
\donttest{
task = makeClassifTask(data = iris, target = "Species")
lrn = makeLearner("classif.rpart")
# stupid mini grid
ps = makeParamSet(
  makeDiscreteParam("cp", values = c(0.05, 0.1)),
  makeDiscreteParam("minsplit", values = c(10, 20))
)
ctrl = makeTuneControlGrid()
inner = makeResampleDesc("Holdout")
outer = makeResampleDesc("CV", iters = 2)
lrn = makeTuneWrapper(lrn, resampling = inner, par.set = ps, control = ctrl)
mod = train(lrn, task)
print(getTuneResult(mod))
# nested resampling for evaluation
# we also extract tuned hyper pars in each iteration
r = resample(lrn, task, outer, extract = getTuneResult)
print(r$extract)
getNestedTuneResultsOptPathDf(r)
getNestedTuneResultsX(r)
}
}
\seealso{
Other tune: 
\code{\link{TuneControl}},
\code{\link{getNestedTuneResultsOptPathDf}()},
\code{\link{getNestedTuneResultsX}()},
\code{\link{getResamplingIndices}()},
\code{\link{getTuneResult}()},
\code{\link{makeModelMultiplexerParamSet}()},
\code{\link{makeModelMultiplexer}()},
\code{\link{makeTuneControlCMAES}()},
\code{\link{makeTuneControlDesign}()},
\code{\link{makeTuneControlGenSA}()},
\code{\link{makeTuneControlGrid}()},
\code{\link{makeTuneControlIrace}()},
\code{\link{makeTuneControlMBO}()},
\code{\link{makeTuneControlRandom}()},
\code{\link{tuneParams}()},
\code{\link{tuneThreshold}()}

Other wrapper: 
\code{\link{makeBaggingWrapper}()},
\code{\link{makeClassificationViaRegressionWrapper}()},
\code{\link{makeConstantClassWrapper}()},
\code{\link{makeCostSensClassifWrapper}()},
\code{\link{makeCostSensRegrWrapper}()},
\code{\link{makeDownsampleWrapper}()},
\code{\link{makeDummyFeaturesWrapper}()},
\code{\link{makeExtractFDAFeatsWrapper}()},
\code{\link{makeFeatSelWrapper}()},
\code{\link{makeFilterWrapper}()},
\code{\link{makeImputeWrapper}()},
\code{\link{makeMulticlassWrapper}()},
\code{\link{makeMultilabelBinaryRelevanceWrapper}()},
\code{\link{makeMultilabelClassifierChainsWrapper}()},
\code{\link{makeMultilabelDBRWrapper}()},
\code{\link{makeMultilabelNestedStackingWrapper}()},
\code{\link{makeMultilabelStackingWrapper}()},
\code{\link{makeOverBaggingWrapper}()},
\code{\link{makePreprocWrapperCaret}()},
\code{\link{makePreprocWrapper}()},
\code{\link{makeRemoveConstantFeaturesWrapper}()},
\code{\link{makeSMOTEWrapper}()},
\code{\link{makeUndersampleWrapper}()},
\code{\link{makeWeightedClassesWrapper}()}
}
\concept{tune}
\concept{wrapper}
