% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/summarizeColumns.R
\name{summarizeColumns}
\alias{summarizeColumns}
\title{Summarize columns of data.frame or task.}
\usage{
summarizeColumns(obj)
}
\arguments{
\item{obj}{[\code{data.frame} | \code{\link{Task}}]\cr
Input data.}
}
\value{
[\code{data.frame}]. With columns:
  \item{name}{Name of column.}
  \item{type}{Data type of column.}
  \item{na}{Number of NAs in column.}
  \item{disp}{Measure of dispersion, for numerics and integers \code{\link{sd}} is used, for
    categorical columns the qualitative variation.}
  \item{mean}{Mean value of column, NA for categorical columns.}
  \item{median}{Median value of column, NA for categorical columns.}
  \item{mad}{MAD of column, NA for categorical columns.}
  \item{min}{Minimal value of column, for categorical columns the size of the smallest category.}
  \item{max}{Maximal value of column, for categorical columns the size of the largest category.}
  \item{nlevs}{For categorical columns, the number of factor levels, NA else.}
}
\description{
Summarizes a data.frame, somewhat differently than the normal \code{\link{summary}} function of R.
The function is mainly useful as a basic EDA tool on data.frames before they are converted to tasks,
but can be used on tasks as well.

Columns can be of type numeric, integer, logical, factor, or character.
Characters and logicals will be treated as factors.
}
\examples{
summarizeColumns(iris)
}
\seealso{
Other eda_and_preprocess: \code{\link{capLargeValues}};
  \code{\link{createDummyFeatures}};
  \code{\link{dropFeatures}};
  \code{\link{mergeSmallFactorLevels}};
  \code{\link{normalizeFeatures}};
  \code{\link{removeConstantFeatures}}
}

