% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult.R
\docType{data}
\name{BenchmarkResult}
\alias{BenchmarkResult}
\title{Container for Results of \code{benchmark()}}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the result container object returned by \code{\link[=benchmark]{benchmark()}}.

Note that all stored objects are accessed by reference.
Do not modify any object without cloning it first.
}
\section{Construction}{
\preformatted{bmr = BenchmarkResult$new(data)
}
\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table with data for one resampling iteration per row:
\link{Task}, \link{Learner}, \link{Resampling}, iteration (\code{integer(1)}), \link{Prediction}, and the hash (\code{character(1)})
of the corresponding \link{ResampleResult}.
}
}

\section{Fields}{

\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Internal data storage.
We discourage users to directly work with this field.
\item \code{tasks} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used tasks with three columns:
\code{"task_hash"} (\code{character(1)}), \code{"task_id"} (\code{character(1)}) and \code{"task"} (\link{Task}).
\item \code{learners} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used learners with three columns:
\code{"learner_hash"} (\code{character(1)}), \code{"learner_id"} (\code{character(1)}) and \code{"learner"} (\link{Learner}).
\item \code{resamplings} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used resamplings with three columns:
\code{"resampling_hash"} (\code{character(1)}), \code{"resampling_id"} (\code{character(1)}) and \code{"resampling"} (\link{Resampling}).
}
}

\section{Methods}{

\itemize{
\item \code{aggregate(measures = NULL, ids = TRUE, params = FALSE, warnings = FALSE, errors = FALSE)}\cr
(\code{list()} of \link{Measure}, \code{logical(1)}, \code{logical(1)}, \code{logical(1)}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a result table where resampling iterations are aggregated together into \link{ResampleResult}s.
Arguments control the number of additional columns:
\itemize{
\item \code{ids} :: \code{logical(1)}\cr
Adds object ids (\code{"task_id"}, \code{"learner_id"}, \code{"resampling_id"}) as extra character columns.
\item \code{params} :: \code{logical(1)}\cr
Adds the hyperparameter values as extra list column \code{"params"}.
You can unnest them with \code{\link[mlr3misc:unnest]{mlr3misc::unnest()}}.
\item \code{warnings} :: \code{logical(1)}\cr
Adds the number of resampling iterations with at least one warning as extra integer column \code{"warnings"}.
\item \code{errors} :: \code{logical(1)}\cr
Adds the number of resampling iterations with errors as extra integer column \code{"errors"}.
}
\item \code{performance(measures = NULL, ids = TRUE)}\cr
(\code{list()} of \link{Measure}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with one row for each resampling iteration, including all involved objects.
Additionally calculates the provided performance measures and binds the performance as extra column.
If \code{ids} is \code{TRUE}, character column of id names are added to the table for convenient filtering.
\item \code{best(measure)}\cr
(\link{Measure}) -> \link{ResampleResult}\cr
Returns the \link{ResampleResult} with the best performance according to \link{Measure}.
\item \code{resample_result(hash)}\cr
(\code{character(1)} -> \link{ResampleResult})\cr
Retrieve the \link{ResampleResult} with hash \code{hash}.
\item \code{combine(bmr)}\cr
\link{BenchmarkResult} -> \code{self}\cr
Fuses a second \link{BenchmarkResult} into itself, mutating the BenchmarkResult in-place.
}
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table(bmr)}\cr
\link{BenchmarkResult} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a copy of the internal data.
}
}

\section{Syntactic Sugar}{


The mlr3 package provides some shortcuts to ease the creation of its objects.

First, instead of an object, it is possible to pass a string identifier which is used to lookup the object in a \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}:
\itemize{
\item \link{Task} in \link{mlr_tasks}.
\item \link{Learner} in \link{mlr_learners}.
\item \link{Resampling} in \link{mlr_resamplings}.
\item \link{Measure} in \link{mlr_measures}.
}

Additionally, each task type has an associated default measure (stored in \link{mlr_reflections}) which is used as a fallback if no other measure is provided.
Classification tasks default to the classification error in \link[=mlr_measures_classif.ce]{"classif.ce"}, regression tasks to the mean squared error in \link[=mlr_measures_regr.mse]{"regr.mse"}.
}

\examples{
set.seed(123)
tasks = mlr_tasks$mget(c("sonar", "spam"))
learners = mlr_learners$mget(c("classif.featureless", "classif.rpart"), predict_type = "prob")
resamplings = mlr_resamplings$get("cv3")
design = expand_grid(tasks = tasks, learners = learners, resamplings = resamplings)
print(design)

bmr = benchmark(design)
print(bmr)

bmr$tasks
bmr$learners

# first 5 individual resamplings
head(as.data.table(bmr, measures = c("classif.acc", "classif.auc")), 5)

# aggregate results
bmr$aggregate()

# aggregate results with hyperparameters as separate columns
mlr3misc::unnest(bmr$aggregate(params = TRUE), "params")

# extract resample result for classif.rpart
rr = bmr$aggregate()[learner_id == "classif.rpart", resample_result][[1]]
print(rr)

# access the confusion matrix of the first resampling iteration
rr$data$prediction[[1]]$confusion
}
\keyword{datasets}
