% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult.R
\docType{data}
\name{BenchmarkResult}
\alias{BenchmarkResult}
\title{Container for Results of \code{benchmark()}}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the result container object returned by \code{\link[=benchmark]{benchmark()}}.
A \link{BenchmarkResult} consists of the data row-binded data of multiple \link{ResampleResult}s,
which can easily be re-constructed.

Note that all stored objects are accessed by reference.
Do not modify any object without cloning it first.
}
\section{Construction}{
\preformatted{bmr = BenchmarkResult$new(data = data.table())
}
\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table with data for one resampling iteration per row:
\link{Task}, \link{Learner}, \link{Resampling}, iteration (\code{integer(1)}), \link{Prediction}, and the unique
hash \code{uhash} (\code{character(1)}) of the corresponding \link{ResampleResult}.
Additional columns are kept in the resulting object.
}
}

\section{Fields}{

\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Internal data storage with one row per resampling iteration.
Can be joined with \code{$rr_data} by joining on column \code{"hash"}.
We discourage users to directly work with this table.

Package develops on the other hand may opt to add additional columns here.
These columns are preserved in all mutators.
\item \code{rr_data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Internal data storage with one row per \link{ResampleResult}.
Can be joined with \code{$data} by joining on column \code{"hash"}.
Not used in \code{mlr3} directly, but can be exploited by add-on packages.

Package develops may opt to add additional columns here.
These columns are preserved in all mutators.
\item \code{task_type} :: \code{character(1)}\cr
Task type of objects in the \code{BenchmarkResult}.
All stored objects (\link{Task}, \link{Learner}, \link{Prediction}) in a single \code{BenchmarkResult} are required to have the same task type, e.g., \code{"classif"} or \code{"regr"}.
\item \code{tasks} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used tasks with three columns:
\code{"task_hash"} (\code{character(1)}), \code{"task_id"} (\code{character(1)}) and \code{"task"} (\link{Task}).
\item \code{learners} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used learners with three columns:
\code{"learner_hash"} (\code{character(1)}), \code{"learner_id"} (\code{character(1)}) and \code{"learner"} (\link{Learner}).
\item \code{resamplings} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used resamplings with three columns:
\code{"resampling_hash"} (\code{character(1)}), \code{"resampling_id"} (\code{character(1)}) and \code{"resampling"} (\link{Resampling}).
\item \code{n_resample_results} :: \code{integer(1)}\cr
Returns the number of stored \link{ResampleResult}s.
\item \code{uhashes} :: \code{character()}\cr
Vector of unique hashes of all included \link{ResampleResult}s.
}
}

\section{Methods}{

\itemize{
\item \code{aggregate(measures = NULL, ids = TRUE, uhashes = FALSE, params = FALSE, conditions = FALSE)}\cr
(list of \link{Measure}, \code{logical(1)}, \code{logical(1)}, \code{logical(1)}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a result table where resampling iterations are combined into \link{ResampleResult}s.
A column with the aggregated performance score is added for each \link{Measure}, named with the id of the respective measure.

For convenience, the following parameters can be set to extract more information from the returned \link{ResampleResult}:
\itemize{
\item \code{uhashes} :: \code{logical(1)}\cr
Adds the uhash values of the \link{ResampleResult} as extra character column \code{"uhash"}.
\item \code{ids} :: \code{logical(1)}\cr
Adds object ids (\code{"task_id"}, \code{"learner_id"}, \code{"resampling_id"}) as extra character columns.
\item \code{params} :: \code{logical(1)}\cr
Adds the hyperparameter values as extra list column \code{"params"}.
You can unnest them with \code{\link[mlr3misc:unnest]{mlr3misc::unnest()}}.
\item \code{conditions} :: \code{logical(1)}\cr
Adds the number of resampling iterations with at least one warning as extra integer column \code{"warnings"}, and
the number of resampling iterations with errors as extra integer column \code{"errors"}.
}
\item \code{score(measures = NULL, ids = TRUE)}\cr
(list of \link{Measure}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with one row for each resampling iteration, including all involved objects:
\link{Task}, \link{Learner}, \link{Resampling}, iteration number (\code{integer(1)}), and \link{Prediction}.
If \code{ids} is set to \code{TRUE}, character column of extracted ids are added to the table for convenient filtering: \code{"task_id"}, \code{"learner_id"}, and \code{"resampling_id"}.
Additionally calculates the provided performance measures and binds the performance as extra columns.
These columns are named using the id of the respective \link{Measure}.
\item \code{resample_result(i = NULL, uhash = NULL)}\cr
(\code{integer(1)}, \code{character(1)}) -> \link{ResampleResult}\cr
Retrieve the i-th \link{ResampleResult}, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\item \code{combine(bmr)}\cr
(\link{BenchmarkResult} | \code{NULL}) -> \code{self}\cr
Fuses a second \link{BenchmarkResult} into itself, mutating the \link{BenchmarkResult} in-place.
If \code{bmr} is \code{NULL}, simply returns \code{self}.
}
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table(bmr)}\cr
\link{BenchmarkResult} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a copy of the internal data.
}
}

\examples{
set.seed(123)
learners = list(
  lrn("classif.featureless", predict_type = "prob"),
  lrn("classif.rpart", predict_type = "prob")
)

design = benchmark_grid(
  tasks = list(tsk("sonar"), tsk("spam")),
  learners = learners,
  resamplings = rsmp("cv", folds = 3)
)
print(design)

bmr = benchmark(design)
print(bmr)

bmr$tasks
bmr$learners

# first 5 individual resamplings
head(as.data.table(bmr, measures = c("classif.acc", "classif.auc")), 5)

# aggregate results
bmr$aggregate()

# aggregate results with hyperparameters as separate columns
mlr3misc::unnest(bmr$aggregate(params = TRUE), "params")

# extract resample result for classif.rpart
rr = bmr$aggregate()[learner_id == "classif.rpart", resample_result][[1]]
print(rr)

# access the confusion matrix of the first resampling iteration
rr$predictions()[[1]]$confusion
}
\keyword{datasets}
