% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif.R
\docType{data}
\name{TaskClassif}
\alias{TaskClassif}
\title{Classification Task}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Task}/\link{TaskSupervised}.}
\description{
This task specializes \link{Task} and \link{TaskSupervised} for classification problems.
The target column is assumed to be a factor.
The \code{task_type} is set to \code{"classif"}.

Additional task properties include:
\itemize{
\item \code{"twoclass"}: The task is a binary classification problem.
\item \code{"multiclass"}: The task is a multiclass classification problem.
}

Predefined tasks are stored in the \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} \link{mlr_tasks}.
}
\section{Construction}{
\preformatted{t = TaskClassif$new(id, backend, target, positive = NULL)
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier for the task.
\item \code{backend} :: \link{DataBackend}\cr
Either a \link{DataBackend}, or any object which is convertible to a DataBackend with \code{as_data_backend()}.
E.g., a \code{data.frame()} will be converted to a \link{DataBackendDataTable}.
\item \code{target} :: \code{character(1)}\cr
Name of the target column.
\item \code{positive} :: \code{character(1)}\cr
Only for binary classification: Name of the positive class.
The levels of the target columns are reordered accordingly, so that the first element of \code{$class_names} is the
positive class, and the second element is the negative class.
}
}

\section{Fields}{

All methods from \link{TaskSupervised}, and additionally:
\itemize{
\item \code{class_names} :: \code{character()}\cr
Returns all class labels of the target column.
\item \code{positive} :: \code{character(1)}\cr
Stores the positive class for binary classification tasks, and \code{NA} for multiclass tasks.
To switch the positive class, assign a level to this field.
\item \code{negative} :: \code{character(1)}\cr
Stores the negative class for binary classification tasks, and \code{NA} for multiclass tasks.
}
}

\section{Methods}{

See \link{TaskSupervised}.
}

\examples{
data("Sonar", package = "mlbench")
task = TaskClassif$new("sonar", backend = Sonar, target = "Class", positive = "M")

task$task_type
task$formula()
task$truth()
task$class_names
task$positive

# possible properties:
mlr_reflections$task_properties$classif
}
\seealso{
Example classification tasks: \code{\link[=mlr_tasks_iris]{iris}}

Other Task: \code{\link{TaskRegr}},
  \code{\link{TaskSupervised}}, \code{\link{Task}},
  \code{\link{mlr_tasks}}
}
\concept{Task}
\keyword{datasets}
