% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpExplicitPta.R
\name{mlr_pipeops_explicit_pta}
\alias{mlr_pipeops_explicit_pta}
\alias{PipeOpExplicitPta}
\title{PipeOpExplicitPta}
\format{
\link{R6Class} object inheriting from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Turns the column with column role 'pta' into an explicit separate column prefixed with "..\emph{internal_pta}".
This keeps it from getting changed or adapted by subsequent pipelines that operate on the feature pta.
}
\section{Construction}{
\preformatted{PipeOpExplicitPta$new(id = "reweighing", param_vals = list())
}
\itemize{
\item \code{id} (\code{character(1)}).
\item \code{param_vals} (\code{list()})
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \link{PipeOpTaskPreproc}. Instead of a \link[mlr3:Task]{Task}, a
\link[mlr3:TaskClassif]{TaskClassif} is used as input and output during training and prediction.

The output during training is the input \link[mlr3:Task]{Task} with added weights column according
to target class. The output during prediction is the unchanged input.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \link[mlr3pipelines:PipeOpTaskPreproc]{PipeOpTaskPreproc}.
}

\section{Parameters}{

The PipeOp does not have any hyperparameters.
}

\section{Internals}{

Copies the existing pta column to a new column.
}

\section{Fields}{

Only fields inherited from \link{PipeOpTaskPreproc}/\code{\link{PipeOp}}.
}

\section{Methods}{

Methods inherited from \link[mlr3pipelines:PipeOpTaskPreproc]{PipeOpTaskPreproc}/\link[mlr3pipelines:PipeOp]{PipeOp}.
}

\examples{
library(mlr3pipelines)
epta = po("explicit_pta")
new = epta$train(list(tsk("adult_train")))
}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other PipeOps: 
\code{\link{mlr_pipeops_equalized_odds}},
\code{\link{mlr_pipeops_reweighing}}
}
\concept{PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{PipeOpExplicitPta}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpExplicitPta$new()}}
\item \href{#method-clone}{\code{PipeOpExplicitPta$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this [R6][R6::R6Class][PipeOp] R6 class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpExplicitPta$new(id = "explicit_pta", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
The PipeOps identifier in the PipeOps library.}

\item{\code{param_vals}}{\code{list} \cr
The parameter values to be set. See \code{Parameters}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpExplicitPta$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
