% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFPCA.R
\name{mlr_pipeops_fda.fpca}
\alias{mlr_pipeops_fda.fpca}
\alias{PipeOpFPCA}
\title{Functional Principal Component Analysis}
\description{
This \code{PipeOp} applies a functional principal component analysis (FPCA) to functional columns and then
extracts the principal components as features. This is done using a (truncated) weighted SVD.

To apply this \code{PipeOp} to irregualr data, convert it to a regular grid first using \code{\link{PipeOpFDAInterpol}}.

For more details, see \code{\link[tf:tfb_fpc]{tfb_fpc()}}, which is called internally.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreproc}}, as well as the following parameters:
\itemize{
\item \code{pve} :: \code{numeric(1)} \cr
The percentage of variance explained that should be retained. Default is \code{0.995}.
\item \code{n_components} :: \code{integer(1)} \cr
The number of principal components to extract. This parameter is initialized to \code{Inf}.
}
}

\section{Naming}{

The new names generally append a \verb{_pc_\{number\}} to the corresponding column name.
If a column was called \code{"x"} and the there are three principcal components, the corresponding
new columns will be called \verb{"x_pc_1", "x_pc_2", "x_pc_3"}.
}

\examples{
library(mlr3pipelines)

task = tsk("fuel")
po_fpca = po("fda.fpca", n_components = 3L)
task_fpca = po_fpca$train(list(task))[[1L]]
task_fpca$data()
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{PipeOpFPCA}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFPCA-new}{\code{PipeOpFPCA$new()}}
\item \href{#method-PipeOpFPCA-clone}{\code{PipeOpFPCA$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFPCA-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFPCA-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFPCA$new(id = "fda.fpca", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default is \code{"fda.fpca"}.}

\item{\code{param_vals}}{(named \code{list})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFPCA-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFPCA-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFPCA$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
