% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_loop_functions.R
\docType{data}
\name{mlr_loop_functions}
\alias{mlr_loop_functions}
\title{Dictionary of Loop Functions}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\arguments{
\item{key}{(\code{character(1)}).}

\item{...}{(\code{any})\cr
Passed down to constructor.}
}
\value{
Object with corresponding key.
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \code{loop_function}.
Each loop function has an associated help page, see \code{mlr_loop_functions_[id]}.

Retrieves object with key \code{key} from the dictionary.
Additional arguments must be named and are passed to the constructor of the stored object.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\examples{
library(data.table)
as.data.table(mlr_loop_functions)
}
\seealso{
Other Dictionary: 
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_input_trafos}},
\code{\link{mlr_output_trafos}},
\code{\link{mlr_result_assigners}}

Other Loop Function: 
\code{\link{loop_function}},
\code{\link{mlr_loop_functions_ego}},
\code{\link{mlr_loop_functions_emo}},
\code{\link{mlr_loop_functions_mpcl}},
\code{\link{mlr_loop_functions_parego}},
\code{\link{mlr_loop_functions_smsego}}
}
\concept{Dictionary}
\concept{Loop Function}
\keyword{datasets}
