% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion_matrix.R
\name{confusion_matrix}
\alias{confusion_matrix}
\title{Calculate Binary Confusion Matrix}
\usage{
confusion_matrix(truth, response, positive, na_value = NaN, relative = FALSE)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have the exactly same two levels and the same length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have the exactly same two levels and the same length as \code{truth}.}

\item{positive}{:: \code{character(1)}\cr
Name of the positive class.}

\item{na_value}{:: \code{numeric(1)}\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{relative}{:: \code{logical(1)}\cr
If \code{TRUE}, the returned confusion matrix contains relative frequencies
instead of absolute frequencies.}
}
\value{
List with two elements:
\itemize{
\item \code{matrix} stores the calculated confusion matrix.
\item \code{measures} stores the metrics as named numeric vector.
}
}
\description{
Calculates the confusion matrix for a binary classification problem
once and then calculates all confusion measures of this package.
}
\examples{
set.seed(123)
lvls = c("a", "b")
truth = factor(sample(lvls, 20, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 20, replace = TRUE), levels = lvls)

confusion_matrix(truth, response, positive = "a")
confusion_matrix(truth, response, positive = "a", relative = TRUE)
confusion_matrix(truth, response, positive = "b")
}
