% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_pbias.R
\name{pbias}
\alias{pbias}
\title{Percent Bias}
\usage{
pbias(truth, response, sample_weights = NULL, na_value = NaN, ...)
}
\arguments{
\item{truth}{(\code{numeric()})\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{(\code{numeric()})\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed response with predicted response in regression tasks.
}
\details{
The Percent Bias is defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n w_i \frac{\left( t_i - r_i \right)}{\left| t_i \right|},
}{
  weighted.mean((t - r) / abs(t), w),
}
where \eqn{w_i} are normalized sample weights.
Good predictions score close to 0.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{(-\infty, \infty)}{(-Inf, Inf)}
\item Minimize: \code{NA}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
pbias(truth, response)
}
\seealso{
Other Regression Measures: 
\code{\link{ae}()},
\code{\link{ape}()},
\code{\link{bias}()},
\code{\link{ktau}()},
\code{\link{linex}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{mse}()},
\code{\link{msle}()},
\code{\link{pinball}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{se}()},
\code{\link{sle}()},
\code{\link{smape}()},
\code{\link{srho}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
