% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchModel.R
\name{mlr_pipeops_torch_model}
\alias{mlr_pipeops_torch_model}
\alias{PipeOpTorchModel}
\title{PipeOp Torch Model}
\description{
Builds a Torch Learner from a \code{\link{ModelDescriptor}} and trains it with the given parameter specification.
The task type must be specified during construction.
}
\section{Input and Output Channels}{

There is one input channel \code{"input"} that takes in \code{ModelDescriptor} during traing and a \code{Task} of the specified
\code{task_type} during prediction.
The output is \code{NULL} during training and a \code{Prediction} of given \code{task_type} during prediction.
}

\section{State}{

A trained \code{\link{LearnerTorchModel}}.
}

\section{Parameters}{


\strong{General}:

The parameters of the optimizer, loss and callbacks,
prefixed with \code{"opt."}, \code{"loss."} and \code{"cb.<callback id>."} respectively, as well as:
\itemize{
\item \code{epochs} :: \code{integer(1)}\cr
The number of epochs.
\item \code{device} :: \code{character(1)}\cr
The device. One of \code{"auto"}, \code{"cpu"}, or \code{"cuda"} or other values defined in \code{mlr_reflections$torch$devices}.
The value is initialized to \code{"auto"}, which will select \code{"cuda"} if possible, then try \code{"mps"} and otherwise
fall back to \code{"cpu"}.
\item \code{num_threads} :: \code{integer(1)}\cr
The number of threads for intraop pararallelization (if \code{device} is \code{"cpu"}).
This value is initialized to 1.
\item \code{seed} :: \code{integer(1)} or \code{"random"}\cr
The seed that is used during training and prediction.
This value is initialized to \code{"random"}, which means that a random seed will be sampled at the beginning of the
training phase. This seed (either set or randomly sampled) is available via \verb{$model$seed} after training
and used during prediction.
Note that by setting the seed during the training phase this will mean that by default (i.e. when \code{seed} is
\code{"random"}), clones of the learner will use a different seed.
}

\strong{Evaluation}:
\itemize{
\item \code{measures_train} :: \code{\link[mlr3:Measure]{Measure}} or \code{list()} of \code{\link[mlr3:Measure]{Measure}}s.\cr
Measures to be evaluated during training.
\item \code{measures_valid} :: \code{\link[mlr3:Measure]{Measure}} or \code{list()} of \code{\link[mlr3:Measure]{Measure}}s.\cr
Measures to be evaluated during validation.
\item \code{eval_freq} :: \code{integer(1)}\cr
How often the train / validation predictions are evaluated using \code{measures_train} / \code{measures_valid}.
This is initialized to \code{1}.
Note that the final model is always evaluated.
}

\strong{Early Stopping}:
\itemize{
\item \code{patience} :: \code{integer(1)}\cr
This activates early stopping using the validation scores.
If the performance of a model does not improve for \code{patience} evaluation steps, training is ended.
Note that the final model is stored in the learner, not the best model.
This is initialized to \code{0}, which means no early stopping.
The first entry from \code{measures_valid} is used as the metric.
This also requires to specify the \verb{$validate} field of the Learner, as well as \code{measures_valid}.
\item \code{min_delta} :: \code{double(1)}\cr
The minimum improvement threshold (\code{>}) for early stopping.
Is initialized to 0.
}

\strong{Dataloader}:
\itemize{
\item \code{batch_size} :: \code{integer(1)}\cr
The batch size (required).
\item \code{shuffle} :: \code{logical(1)}\cr
Whether to shuffle the instances in the dataset. Default is \code{FALSE}.
This does not impact validation.
\item \code{sampler} :: \code{\link[torch:sampler]{torch::sampler}}\cr
Object that defines how the dataloader draw samples.
\item \code{batch_sampler} :: \code{\link[torch:sampler]{torch::sampler}}\cr
Object that defines how the dataloader draws batches.
\item \code{num_workers} :: \code{integer(1)}\cr
The number of workers for data loading (batches are loaded in parallel).
The default is \code{0}, which means that data will be loaded in the main process.
\item \code{collate_fn} :: \code{function}\cr
How to merge a list of samples to form a batch.
\item \code{pin_memory} :: \code{logical(1)}\cr
Whether the dataloader copies tensors into CUDA pinned memory before returning them.
\item \code{drop_last} :: \code{logical(1)}\cr
Whether to drop the last training batch in each epoch during training. Default is \code{FALSE}.
\item \code{timeout} :: \code{numeric(1)}\cr
The timeout value for collecting a batch from workers.
Negative values mean no timeout and the default is \code{-1}.
\item \code{worker_init_fn} :: \verb{function(id)}\cr
A function that receives the worker id (in \verb{[1, num_workers]}) and is exectued after seeding
on the worker but before data loading.
\item \code{worker_globals} :: \code{list()} | \code{character()}\cr
When loading data in parallel, this allows to export globals to the workers.
If this is a character vector, the objects in the global environment with those names
are copied to the workers.
\item \code{worker_packages} :: \code{character()}\cr
Which packages to load on the workers.
}

Also see \code{torch::dataloder} for more information.
}

\section{Internals}{

A \code{\link{LearnerTorchModel}} is created by calling \code{\link[=model_descriptor_to_learner]{model_descriptor_to_learner()}} on the
provided \code{\link{ModelDescriptor}} that is received through the input channel.
Then the parameters are set according to the parameters specified in \code{PipeOpTorchModel} and
its '$train()\verb{ method is called on the [}Task\verb{][mlr3::Task] stored in the [}ModelDescriptor`].
}

\seealso{
Other PipeOps: 
\code{\link{mlr_pipeops_nn_avg_pool1d}},
\code{\link{mlr_pipeops_nn_avg_pool2d}},
\code{\link{mlr_pipeops_nn_avg_pool3d}},
\code{\link{mlr_pipeops_nn_batch_norm1d}},
\code{\link{mlr_pipeops_nn_batch_norm2d}},
\code{\link{mlr_pipeops_nn_batch_norm3d}},
\code{\link{mlr_pipeops_nn_block}},
\code{\link{mlr_pipeops_nn_celu}},
\code{\link{mlr_pipeops_nn_conv1d}},
\code{\link{mlr_pipeops_nn_conv2d}},
\code{\link{mlr_pipeops_nn_conv3d}},
\code{\link{mlr_pipeops_nn_conv_transpose1d}},
\code{\link{mlr_pipeops_nn_conv_transpose2d}},
\code{\link{mlr_pipeops_nn_conv_transpose3d}},
\code{\link{mlr_pipeops_nn_dropout}},
\code{\link{mlr_pipeops_nn_elu}},
\code{\link{mlr_pipeops_nn_flatten}},
\code{\link{mlr_pipeops_nn_gelu}},
\code{\link{mlr_pipeops_nn_glu}},
\code{\link{mlr_pipeops_nn_hardshrink}},
\code{\link{mlr_pipeops_nn_hardsigmoid}},
\code{\link{mlr_pipeops_nn_hardtanh}},
\code{\link{mlr_pipeops_nn_head}},
\code{\link{mlr_pipeops_nn_layer_norm}},
\code{\link{mlr_pipeops_nn_leaky_relu}},
\code{\link{mlr_pipeops_nn_linear}},
\code{\link{mlr_pipeops_nn_log_sigmoid}},
\code{\link{mlr_pipeops_nn_max_pool1d}},
\code{\link{mlr_pipeops_nn_max_pool2d}},
\code{\link{mlr_pipeops_nn_max_pool3d}},
\code{\link{mlr_pipeops_nn_merge}},
\code{\link{mlr_pipeops_nn_merge_cat}},
\code{\link{mlr_pipeops_nn_merge_prod}},
\code{\link{mlr_pipeops_nn_merge_sum}},
\code{\link{mlr_pipeops_nn_prelu}},
\code{\link{mlr_pipeops_nn_relu}},
\code{\link{mlr_pipeops_nn_relu6}},
\code{\link{mlr_pipeops_nn_reshape}},
\code{\link{mlr_pipeops_nn_rrelu}},
\code{\link{mlr_pipeops_nn_selu}},
\code{\link{mlr_pipeops_nn_sigmoid}},
\code{\link{mlr_pipeops_nn_softmax}},
\code{\link{mlr_pipeops_nn_softplus}},
\code{\link{mlr_pipeops_nn_softshrink}},
\code{\link{mlr_pipeops_nn_softsign}},
\code{\link{mlr_pipeops_nn_squeeze}},
\code{\link{mlr_pipeops_nn_tanh}},
\code{\link{mlr_pipeops_nn_tanhshrink}},
\code{\link{mlr_pipeops_nn_threshold}},
\code{\link{mlr_pipeops_torch_ingress}},
\code{\link{mlr_pipeops_torch_ingress_categ}},
\code{\link{mlr_pipeops_torch_ingress_ltnsr}},
\code{\link{mlr_pipeops_torch_ingress_num}},
\code{\link{mlr_pipeops_torch_loss}},
\code{\link{mlr_pipeops_torch_model_classif}},
\code{\link{mlr_pipeops_torch_model_regr}}
}
\concept{PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpLearner]{mlr3pipelines::PipeOpLearner}} -> \code{PipeOpTorchModel}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTorchModel-new}{\code{PipeOpTorchModel$new()}}
\item \href{#method-PipeOpTorchModel-clone}{\code{PipeOpTorchModel$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchModel-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchModel$new(task_type, id = "torch_model", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task_type}}{(\code{character(1)})\cr
The task type of the model.}

\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
