% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorClockTime.R
\name{TerminatorClockTime}
\alias{TerminatorClockTime}
\alias{mlr_terminators_clock_time}
\title{Terminator that stops according to the clock time}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Terminator}.}
\description{
Class to terminate the tuning either after the complete process took a number of seconds on the clock
or a fixed time point has been reached (as reported by \code{\link[=Sys.time]{Sys.time()}}).
}
\section{Construction}{
\preformatted{TerminatorClockTime$new()
term("clock_time")
}
}

\section{Parameters}{

\itemize{
\item \code{secs} :: \code{numeric(1)}\cr
Maximum allowed time, in seconds, default is 100.
Mutually exclusive with argument \code{stop_time}.
\item \code{stop_time} :: \code{POSIXct(1)}\cr
Terminator stops after this point in time.
Mutually exclusive with argument \code{secs}.
}
}

\examples{
term("clock_time", secs = 1800)

stop_time = as.POSIXct("2030-01-01 00:00:00")
term("clock_time", stop_time = stop_time)
}
\seealso{
Other Terminator: 
\code{\link{TerminatorCombo}},
\code{\link{TerminatorEvals}},
\code{\link{TerminatorModelTime}},
\code{\link{TerminatorNone}},
\code{\link{TerminatorPerfReached}},
\code{\link{TerminatorStagnation}},
\code{\link{Terminator}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
