% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_inner_tuning_results.R
\name{extract_inner_tuning_results}
\alias{extract_inner_tuning_results}
\title{Extract Inner Tuning Results}
\usage{
extract_inner_tuning_results(x)
}
\arguments{
\item{x}{(\link[mlr3:ResampleResult]{mlr3::ResampleResult} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}).}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
\description{
Extract inner tuning results of nested resampling. Implemented for
\link[mlr3:ResampleResult]{mlr3::ResampleResult} and \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}. The function iterates
over the \link{AutoTuner} objects and binds the tuning results to a
\code{\link[data.table:data.table]{data.table::data.table()}}. \link{AutoTuner} must be initialized with
\code{store_tuning_instance = TRUE} and \code{resample()} or \code{benchmark()} must be
called with \code{store_models = TRUE}.
}
\section{Data structure}{


The returned data table has the following columns:
\itemize{
\item \code{experiment} (integer(1))\cr
Index, giving the according row number in the original benchmark grid.
\item \code{iteration} (integer(1))\cr
Iteration of the outer resampling.
\item One column for each hyperparameter of the search spaces.
\item One column for each performance measure.
\item \code{learner_param_vals} (\code{list()})\cr
Hyperparameter values used by the learner. Includes fixed and proposed
hyperparameter values.
\item \code{x_domain} (\code{list()})\cr
List of transformed hyperparameter values.
\item \code{task_id} (\code{character(1)}).
\item \code{learner_id} (\code{character(1)}).
\item \code{resampling_id} (\code{character(1)}).
}
}

\examples{
learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE))

at = auto_tuner(
  method = "grid_search",
  learner = learner,
  resampling = rsmp ("holdout"),
  measure = msr("classif.ce"),
  term_evals = 4)

resampling_outer = rsmp("cv", folds = 2)
rr = resample(tsk("iris"), at, resampling_outer, store_models = TRUE)

extract_inner_tuning_results(rr)
}
