% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_inner_tuning_archives.R
\name{extract_inner_tuning_archives}
\alias{extract_inner_tuning_archives}
\title{Extract Inner Tuning Archives}
\usage{
extract_inner_tuning_archives(
  x,
  unnest = "x_domain",
  exclude_columns = "uhash"
)
}
\arguments{
\item{x}{(\link[mlr3:ResampleResult]{mlr3::ResampleResult} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}).}

\item{unnest}{(\code{character()})\cr
Transforms list columns to separate columns.
By default, \code{x_domain} is unnested.
Set to \code{NULL} if no column should be unnested.}

\item{exclude_columns}{(\code{character()})\cr
Exclude columns from result table.
Set to \code{NULL} if no column should be excluded.}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
\description{
Extract inner tuning archives of nested resampling.
Implemented for \link[mlr3:ResampleResult]{mlr3::ResampleResult} and \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.
The function iterates over the \link{AutoTuner} objects and binds the tuning archives to a \code{\link[data.table:data.table]{data.table::data.table()}}.
\link{AutoTuner} must be initialized with \code{store_tuning_instance = TRUE} and \code{\link[mlr3:resample]{mlr3::resample()}} or \code{\link[mlr3:benchmark]{mlr3::benchmark()}} must be called with \code{store_models = TRUE}.
}
\section{Data structure}{


The returned data table has the following columns:
\itemize{
\item \code{experiment} (integer(1))\cr
Index, giving the according row number in the original benchmark grid.
\item \code{iteration} (integer(1))\cr
Iteration of the outer resampling.
\item One column for each hyperparameter of the search spaces.
\item One column for each performance measure.
\item \code{runtime_learners} (\code{numeric(1)})\cr
Sum of training and predict times logged in learners per \link[mlr3:ResampleResult]{mlr3::ResampleResult} / evaluation.
This does not include potential overhead time.
\item \code{timestamp} (\code{POSIXct})\cr
Time stamp when the evaluation was logged into the archive.
\item \code{batch_nr} (\code{integer(1)})\cr
Hyperparameters are evaluated in batches.
Each batch has a unique batch number.
\item \code{x_domain} (\code{list()})\cr
List of transformed hyperparameter values.
By default this column is unnested.
\item \verb{x_domain_*} (\code{any})\cr
Separate column for each transformed hyperparameter.
\item \code{resample_result} (\link[mlr3:ResampleResult]{mlr3::ResampleResult})\cr
Resample result of the inner resampling.
\item \code{task_id} (\code{character(1)}).
\item \code{learner_id} (\code{character(1)}).
\item \code{resampling_id} (\code{character(1)}).
}
}

\examples{
learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE))

at = auto_tuner(
  method = "grid_search",
  learner = learner,
  resampling = rsmp ("holdout"),
  measure = msr("classif.ce"),
  term_evals = 4)

resampling_outer = rsmp("cv", folds = 2)
rr = resample(tsk("iris"), at, resampling_outer, store_models = TRUE)

extract_inner_tuning_archives(rr)
}
