% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term_indices.R
\name{term_indices}
\alias{term_indices}
\alias{tiseq}
\alias{term_indices}
\alias{timat}
\title{Convert text to integer indices}
\usage{
tiseq(corpus, vocab, keep_unknown = nbuckets > 0, nbuckets = attr(vocab,
  "nbuckets"), reverse = FALSE)

timat(corpus, vocab, maxlen = 100, pad_right = TRUE, trunc_right = TRUE,
  keep_unknown = nbuckets > 0, nbuckets = attr(vocab, "nbuckets"),
  reverse = FALSE)
}
\arguments{
\item{corpus}{text corpus}

\item{vocab}{data frame produced by \code{\link[=vocab]{vocab()}} or \code{\link[=vocab_update]{vocab_update()}}}

\item{keep_unknown}{logical. If \code{TRUE}, preserve unknowns in the output
sequences.}

\item{nbuckets}{integer. How many buckets to hash unknowns into.}

\item{reverse}{logical. Should each sequence be reversed in the final
output? Reversion happens after \code{pad_right} and \code{trunc_right} have been
applied to the original text sequence. Default \code{FALSE}.}

\item{maxlen}{integer. Maximum length of each sequence.}

\item{pad_right}{logical. Should 0-padding of shorter than \code{maxlen}
sequences happen on the right? Default \code{TRUE}.}

\item{trunc_right}{logical. Should truncation of longer than \code{maxlen}
sequences happen on the right? Default \code{TRUE}.}
}
\value{
\code{\link[=tiseq]{tiseq()}} returns a list of integer vectors, \code{\link[=timat]{timat()}} returns an
integer matrix, one row per sequence.
}
\description{
Convert text to integer indices
}
\examples{
corpus <- list(a = c("The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"), 
               b = c("the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog",
                     "the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"))
v <- vocab(corpus["b"]) # "The" is unknown
v
tiseq(corpus, v)
tiseq(corpus, v, keep_unknown = TRUE)
tiseq(corpus, v, nbuckets = 1)
tiseq(corpus, v, nbuckets = 3)

timat(corpus, v, maxlen = 12)
timat(corpus, v, maxlen = 12, keep_unknown = TRUE)
timat(corpus, v, maxlen = 12, nbuckets = 1)
timat(corpus, v, maxlen = 12, nbuckets = 1, reverse = TRUE)
timat(corpus, v, maxlen = 12, pad_right = FALSE, nbuckets = 1)
timat(corpus, v, maxlen = 12, trunc_right = FALSE, nbuckets = 1)
}
