% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfidf.R
\name{tfidf}
\alias{tfidf}
\title{Tfidf re-weighting of \code{dtm} and \code{tdm} matrices}
\usage{
tfidf(mat, vocab, norm = c("l1", "l2", "none"), sublinear_tf = FALSE,
  extra_df_count = 1)
}
\arguments{
\item{mat}{output of \code{\link[=dtm]{dtm()}} or \code{\link[=tdm]{tdm()}} function}

\item{vocab}{output of \code{\link[=vocab]{vocab()}} or \code{\link[=vocab_update]{vocab_update()}}}

\item{norm}{normalization to apply for each document. Either "l1", "l2" or
"none"}

\item{sublinear_tf}{when \code{TRUE} use \code{1 + log(tf)} instead of the raw \code{tf}}

\item{extra_df_count}{add this number to the document count; as if all terms
in the vocabulary have been seen at least in this many documents.}
}
\description{
Tfidf re-weighting of \code{dtm} and \code{tdm} matrices
}
\examples{
corpus <- list(a = c("The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"), 
               b = c("the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog",
                     "the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"))
v <- vocab(corpus, c(1, 2), " ")
dtm <- dtm(corpus, v)
tfidf(dtm, v)
tdm <- tdm(corpus, v)
tfidf(tdm, v)
}
