% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_funcs.R
\name{pj_pow}
\alias{pj_pow}
\title{Power Calculation for ANOVA Simulation}
\usage{
pj_pow(df_list, constr = 0, alpha = 0.05)
}
\arguments{
\item{df_list}{A list of data frames, each representing a dataset. Designed to
use results generated from the generate_datasets() function.}

\item{constr}{An integer indicating the number of inequality constraints.
A value of 0 indicates that all constraints are equality constraints.
The value must be a non-negative integer less than the number of groups.}

\item{alpha}{The significance level used in the hypothesis testing, with a
default value of 0.05. It should be a numeric value between 0 and 1.}
}
\value{
The function returns the calculated power as a numeric value,
representing the proportion of p-values smaller than the predefined
significance level alpha.
}
\description{
This function calculates the power for hypothesis tests in a constrained
statistical inference setting, particularly in the context of ANOVA and regression
as discussed in Vanbrabant et al. (2015). It is designed to work with a list of
data frames, where each data frame represents a different dataset. The function
accommodates both equality and inequality constraints.
}
\details{
The function first checks the validity of the 'constr' parameter and
then constructs the constraint string based on the number of constraints.
It runs the model for each dataset in the df_list using the mmir_model function
and applies the constraints using the restriktor::iht function. The power is
calculated based on the proportion of datasets that meet the hypothesis test
criteria defined by the constraints and the significance level.
}
\examples{
generate_datasets(S = 2, k = 4, f = 0.25, n = 30) |> pj_pow(constr=1)

}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
