% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_pgsql.R
\name{replext_pgsql}
\alias{replext_pgsql}
\title{Launch Replext Simulation Shiny Application}
\usage{
replext_pgsql(dbname, datatable, host, port, user, password)
}
\arguments{
\item{dbname}{The name of the PostgreSQL database to connect to.}

\item{datatable}{The name of the table in the database where the simulation results will be stored and retrieved.}

\item{host}{The host address of the PostgreSQL database.}

\item{port}{The port number for the PostgreSQL database connection.}

\item{user}{The username for accessing the PostgreSQL database.}

\item{password}{The password for the specified user to access the PostgreSQL database.}
}
\value{
A Shiny app object which can be run to start the application.
}
\description{
This function creates and launches a Shiny web application for running
simulations related to constrained statistical inference in ANOVA and regression
settings. The application allows users to set various parameters for
\code{replext_t1_c1} and \code{replext_t2_c1} functions and view the resulting simulation
data. The simulation is based on Vanbrabant et al. (2015). The app includes
functionality to interact with a PostgreSQL database. The app includes a user
interface for selecting simulation parameters and a server logic to process the
simulation and handle user interactions, including saving and retrieving data
from a database.
}
\details{
The Shiny application consists of a user interface for setting
simulation parameters and a server logic to process the simulations and save
to PostgreSQL database. Users can select between different simulation settings
(cell blocks), specify parameters, run the simulations, view the results in
a table format, submit results to PostgreSQL database, and download the database
table. The application also handles dynamic UI elements based on user
selections and manages data downloads.
}
\examples{
if (interactive()) {
  replext_pgsql(
    dbname = "your_db_name",
    datatable = "your_data_table",
    host = "localhost",
    port = 5432,
    user = "your_username",
    password = "your_password"
  )
}

}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
