% Generated by roxygen2 (4.0.0): do not edit by hand
\name{summarise_bootstrap}
\alias{summarise_bootstrap}
\title{Apply a differentiation statistic to a bootstrap sample}
\usage{
summarise_bootstrap(bs, statistic)
}
\arguments{
\item{bs}{list of genind objects}

\item{statistic}{differentiation statistic to apply (the function itself,
as with apply family functions)}
}
\value{
per.locus:  matrix of statistics calculated for each locus and each
bootstrap replication

global.het: vector of global estimates calculated from overall
heterozygosity

global.het: vector of global estimates calculated from harmonic
mean of statistic (only applied to D_Jost)

summary.loci: matrix containing mean, .025 and 0.975 percentile and
varaince of statisic for each locus

summary.global_het: mean, .025 and 0.975 percentile and variance for
global estimate variance of statistic for each locus based on heterozygosity

summary.global_harm: mean, .025 and 0.975 percentile and variance for
global estimate variance of statistic for each locus based on harmonic mean
}
\description{
This function applies a differentiation statistic (eg, D_Jost, Gst_Hedrick or
Gst_Nei) to a list of genind objects, possibly produced with
chao_bootsrap or jacknife_populations. The resulting list contains a matrix
of values with the statistic for each locus as well as a global estimate
for every object in the sample. Additionally, mean and 95% confidence
intervals are calculated for each set of statisics A custom print method
that displays these summaries is provided.
}
\examples{
\dontrun{
data(nancycats)
bs <- chao_bootstrap(nancycats)
summarise_bootstrap(bs, D_Jost)
}
}
\seealso{
Other resample: \code{\link{chao_bootstrap}};
  \code{\link{jacknife_populations}}
}

