% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{mmrm_control}
\alias{mmrm_control}
\title{Control Parameters for Fitting an MMRM}
\usage{
mmrm_control(
  n_cores = 1L,
  method = c("Satterthwaite", "Kenward-Roger", "Kenward-Roger-Linear"),
  start = NULL,
  accept_singular = TRUE,
  drop_visit_levels = TRUE,
  ...,
  optimizers = h_get_optimizers(...)
)
}
\arguments{
\item{n_cores}{(\code{int})\cr number of cores to be used.}

\item{method}{(\code{string})\cr adjustment method for degrees of freedom and
coefficients covariance matrix.}

\item{start}{(\code{numeric} or \code{NULL})\cr optional start values for variance
parameters.}

\item{accept_singular}{(\code{flag})\cr whether singular design matrices are reduced
to full rank automatically and additional coefficient estimates will be missing.}

\item{drop_visit_levels}{(\code{flag})\cr whether to drop levels for visit variable,
if visit variable is a factor, see details.}

\item{...}{additional arguments passed to \code{\link[=h_get_optimizers]{h_get_optimizers()}}.}

\item{optimizers}{(\code{list})\cr optimizer specification, created with \code{\link[=h_get_optimizers]{h_get_optimizers()}}.}
}
\value{
List of class \code{mmrm_control} with the control parameters.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Fine-grained specification of the MMRM fit details is possible using this
control function.
}
\details{
The \code{drop_visit_levels} flag will decide whether unobserved visits will be kept for analysis.
For example, if the data only has observations at visits \code{VIS1}, \code{VIS3} and \code{VIS4}, by default
they are treated to be equally spaced, the distance from \code{VIS1} to \code{VIS3}, and from \code{VIS3} to \code{VIS4},
are identical. However, you can manually convert this visit into a factor, with
\code{levels = c("VIS1", "VIS2", "VIS3", "VIS4")}, and also use \code{drop_visits_levels = FALSE},
then the distance from \code{VIS1} to \code{VIS3} will be double, as \code{VIS2} is a valid visit.
However, please be cautious because this can lead to convergence failure
when using an unstructured covariance matrix and there are no observations
at the missing visits.
}
\examples{
mmrm_control(
  optimizer_fun = stats::optim,
  optimizer_args = list(method = "L-BFGS-B")
)
}
