% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_constituency_results.R
\name{mnis_constituency_results}
\alias{mnis_constituency_results}
\title{Constituency election results}
\usage{
mnis_constituency_results(
  constituency_id = NULL,
  election_id = 0,
  tidy = TRUE,
  tidy_style = "snake_case"
)
}
\arguments{
\item{constituency_id}{The ID of the constituency to return the data for.
If \code{NULL}, no data is returned. Defaults to \code{NULL}.}

\item{election_id}{The ID of the election to return the data for. Defaults
to 0, which returns the result of all elections held in that constituency.}

\item{tidy}{If \code{TRUE}, fixes the variable names in the tibble to
remove non-alphanumeric characters and superfluous text, and convert to
a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of \code{"snake_case"}, \code{"camelCase"} and
\code{"period.case"}. Defaults to \code{"snake_case"}.}
}
\value{
A list with details of the constituency, labelled \code{'details'}
and a tibble with election results, labelled \code{'results'}. The list and
tibble are stored in a single object.
}
\description{
Returns a list with details of the constituency and a tibble
with election results.
}
\examples{
\dontrun{
x <- mnis_constituency_results(constituency_id = 3709, election_id = 0)
}

}
