% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jt_kde.R
\name{Cond.mod.ap}
\alias{Cond.mod.ap}
\title{Fit bivariate conditional extremes model (from Heffernan and Tawn, 2004 and texmex R package)}
\usage{
Cond.mod.ap(
  u2,
  tr1,
  tr2,
  tsim,
  num.sim,
  pobj,
  interh = "comb",
  mar1,
  mar2,
  px,
  py
)
}
\arguments{
\item{u2}{Two column data frame}

\item{tr1}{extreme threshold for first variable}

\item{tr2}{extreme threshold for second variable}

\item{tsim}{Prediction quantile. The quantile of the conditioning variable above which it will be simulated for importance sampling based prediction (from texmex)}

\item{num.sim}{The number of simulated observations to be generated for prediction (from texmex)}

\item{pobj}{objective joint return period modelled with the conditional extremes model}

\item{interh}{type of hazard interrelation '\code{comb}' for compound and '\code{casc}' for cascade,}

\item{mar1}{Values of the first margin}

\item{mar2}{Values of the second margin}

\item{px}{Uniform values of the first margin with a mixed distribution (empirical below and gpd above a threshold)}

\item{py}{Uniform values of the second margin with a mixed distribution (empirical below and gpd above a threshold)}
}
\value{
a list containing the following:
\itemize{
\item jline - data frame of the objective level curve with the selected return period '\code{pobj}'
\item onlysim - data frame of simulated extreme data for the two variables
\item etaHT - threshold dependent extremal dependence measure
\item chiHT - threshold dependent coefficient of tail dependence
}
}
\description{
Fit bivariate conditional extremes model (from Heffernan and Tawn, 2004 and texmex R package)
}
\examples{
  \dontrun{
condexres<-Cond.mod.ap(u2=fire01meantemp,tr1,tr2,tsim=t.sim,num.sim=10000,
pobj=0.001,mar1=uu[,1],mar2=uu[,2],px=pp[,1],py=pp[,2],interh=interh)
plot(condexres$jline)
}
}
\references{
Tilloy, A., Malamud, B.D., Winter, H. and Joly-Laugel, A., 2020.
Evaluating the efficacy of bivariate extreme modelling approaches
for multi-hazard scenarios. Natural Hazards and Earth System Sciences, 20(8), pp.2091-2117.

Heffernan, J.E. and Tawn, J.A., 2004.
A conditional approach for multivariate extreme values (with discussion).
Journal of the Royal Statistical Society: Series B (Statistical Methodology), 66(3), pp.497-546.
}
\seealso{
\code{\link[texmex]{mex}}
}
