% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_slopes.R
\name{estimate_slopes}
\alias{estimate_slopes}
\title{Estimate the slopes of a numeric predictor (over different factor levels)}
\usage{
estimate_slopes(
  model,
  trend = NULL,
  levels = NULL,
  transform = "response",
  standardize = TRUE,
  standardize_robust = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{trend}{A character indicating the name of the numeric variable for which to compute the slopes.}

\item{levels}{A character vectors indicating the variables over which the slope will be computed. If NULL (default), it will select all the remaining predictors.}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{standardize}{If \code{TRUE}, adds standardized differences or coefficients.}

\item{standardize_robust}{Robust standardization through \code{MAD} (Median Absolute Deviation, a robust estimate of SD) instead of regular \code{SD}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of slopes.
}
\description{
See the documentation for your object's class:
\itemize{
 \item{\link[=estimate_slopes.lm]{Frequentist models}}
 \item{\link[=estimate_slopes.stanreg]{Bayesian models (stanreg and brms)}}
 }
}
