% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_emcontrasts.R, R/get_emmeans.R,
%   R/get_emtrends.R, R/get_marginalcontrasts.R, R/get_marginalmeans.R,
%   R/get_marginaltrends.R
\name{get_emcontrasts}
\alias{get_emcontrasts}
\alias{get_emmeans}
\alias{get_emtrends}
\alias{get_marginalcontrasts}
\alias{get_marginalmeans}
\alias{get_marginaltrends}
\title{Consistent API for 'emmeans' and 'marginaleffects'}
\usage{
get_emcontrasts(
  model,
  contrast = NULL,
  by = NULL,
  predict = NULL,
  comparison = "pairwise",
  transform = NULL,
  verbose = TRUE,
  ...
)

get_emmeans(
  model,
  by = "auto",
  predict = NULL,
  transform = NULL,
  verbose = TRUE,
  ...
)

get_emtrends(model, trend = NULL, by = NULL, verbose = TRUE, ...)

get_marginalcontrasts(
  model,
  contrast = NULL,
  by = NULL,
  predict = NULL,
  ci = 0.95,
  comparison = "pairwise",
  estimate = "average",
  p_adjust = "none",
  transform = NULL,
  verbose = TRUE,
  ...
)

get_marginalmeans(
  model,
  by = "auto",
  predict = NULL,
  ci = 0.95,
  estimate = "average",
  transform = NULL,
  verbose = TRUE,
  ...
)

get_marginaltrends(model, trend = NULL, by = NULL, verbose = TRUE, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{contrast}{A character vector indicating the name of the variable(s)
for which to compute the contrasts.}

\item{by}{The (focal) predictor variable(s) at which to evaluate the desired
effect / mean / contrasts. Other predictors of the model that are not
included here will be collapsed and "averaged" over (the effect will be
estimated across them). The \code{by} argument is used to create a "reference grid"
or "data grid" with representative values for the focal predictors. \code{by}
can be a character (vector) naming the focal predictors (and optionally,
representative values or levels), or a list of named elements. See details
in \code{\link[insight:get_datagrid]{insight::get_datagrid()}} to learn more about how to create data grids
for predictors of interest.}

\item{predict}{Is passed to the \code{type} argument in \code{emmeans::emmeans()} (when
\code{backend = "emmeans"}) or in \code{marginaleffects::avg_predictions()} (when
\code{backend = "marginaleffects"}). For emmeans, see also
\href{https://CRAN.R-project.org/package=emmeans/vignettes/transformations.html}{this vignette}.
Valid options for `predict`` are:
\itemize{
\item \code{backend = "emmeans"}: \code{predict} can be \code{"response"}, \code{"link"}, \code{"mu"},
\code{"unlink"}, or \code{"log"}. If \code{predict = NULL} (default), the most appropriate
transformation is selected (which usually is \code{"response"}).
\item \code{backend = "marginaleffects"}: \code{predict} can be \code{"response"}, \code{"link"} or
any valid \code{type} option supported by model's class \code{predict()} method (e.g.,
for zero-inflation models from package \strong{glmmTMB}, you can choose
\code{predict = "zprob"} or \code{predict = "conditional"} etc., see
\link[glmmTMB:predict.glmmTMB]{glmmTMB::predict.glmmTMB}). By default, when \code{predict = NULL}, the most
appropriate transformation is selected, which usually returns predictions
or contrasts on the response-scale.
}

\code{"link"} will leave the values on scale of the linear predictors.
\code{"response"} (or \code{NULL}) will transform them on scale of the response
variable. Thus for a logistic model, \code{"link"} will give estimations expressed
in log-odds (probabilities on logit scale) and \code{"response"} in terms of
probabilities. To predict distributional parameters (called "dpar" in other
packages), for instance when using complex formulae in \code{brms} models, the
\code{predict} argument can take the value of the parameter you want to estimate,
for instance \code{"sigma"}, \code{"kappa"}, etc.}

\item{comparison}{Specify the type of contrasts or tests that should be
carried out.
\itemize{
\item When \code{backend = "emmeans"}, can be one of \code{"pairwise"}, \code{"poly"},
\code{"consec"}, \code{"eff"}, \code{"del.eff"}, \code{"mean_chg"}, \code{"trt.vs.ctrl"},
\code{"dunnett"}, \code{"wtcon"} and some more. See also \code{method} argument in
\link[emmeans:contrast]{emmeans::contrast} and the \code{?emmeans::emmc-functions}.
\item For \code{backend = "marginaleffects"}, can be a numeric value, vector, or
matrix, a string equation specifying the hypothesis to test, a string
naming the comparison method, a formula, or a function. Strings, string
equations and formula are probably the most common options and described
below. For other options and detailed descriptions of those options, see
also \link[marginaleffects:comparisons]{marginaleffects::comparisons} and
\href{https://marginaleffects.com/bonus/hypothesis.html}{this website}.
\itemize{
\item String: One of \code{"pairwise"}, \code{"reference"}, \code{"sequential"}, \code{"meandev"}
\code{"meanotherdev"}, \code{"poly"}, \code{"helmert"}, or \code{"trt_vs_ctrl"}.
\item String equation: To identify parameters from the output, either specify
the term name, or \code{"b1"}, \code{"b2"} etc. to indicate rows, e.g.:\code{"hp = drat"},
\code{"b1 = b2"}, or \code{"b1 + b2 + b3 = 0"}.
\item Formula: A formula like \code{comparison ~ pairs | group}, where the left-hand
side indicates the type of comparison (\code{difference} or \code{ratio}), the
right-hand side determines the pairs of estimates to compare (\code{reference},
\code{sequential}, \code{meandev}, etc., see string-options). Optionally, comparisons
can be carried out within subsets by indicating the grouping variable
after a vertical bar ( \code{|}).
}
}}

\item{transform}{A function applied to predictions and confidence intervals
to (back-) transform results, which can be useful in case the regression
model has a transformed response variable (e.g., \code{lm(log(y) ~ x)}). For
Bayesian models, this function is applied to individual draws from the
posterior distribution, before computing summaries. Can also be \code{TRUE}, in
which case \code{insight::get_transformation()} is called to determine the
appropriate transformation-function.}

\item{verbose}{Use \code{FALSE} to silence messages and warnings.}

\item{...}{Other arguments passed, for instance, to \code{\link[insight:get_datagrid]{insight::get_datagrid()}},
to functions from the \strong{emmeans} or \strong{marginaleffects} package, or to process
Bayesian models via \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}}. Examples:
\itemize{
\item \code{insight::get_datagrid()}: Argument such as \code{length} or \code{range} can be used
to control the (number of) representative values.
\item \strong{marginaleffects}: Internally used functions are \code{avg_predictions()} for
means and contrasts, and \code{avg_slope()} for slopes. Therefore, arguments
for instance like \code{vcov}, \code{transform}, \code{equivalence}, \code{slope} or even
\code{newdata} can be passed to those functions.
\item \strong{emmeans}: Internally used functions are \code{emmeans()} and \code{emtrends()}.
Additional arguments can be passed to these functions.
\item Bayesian models: For Bayesian models, parameters are cleaned using
\code{describe_posterior()}, thus, arguments like, for example, \code{centrality},
\code{rope_range}, or \code{test} are passed to that function.
}}

\item{trend}{A character indicating the name of the variable for which to
compute the slopes.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{estimate}{Character string, indicating the type of target population
predictions refer to. This dictates how the predictions are "averaged" over
the non-focal predictors, i.e. those variables that are not specified in
\code{by} or \code{contrast}.
\itemize{
\item \code{"average"} (default): Takes the mean value for non-focal numeric
predictors and marginalizes over the factor levels of non-focal terms,
which computes a kind of "weighted average" for the values at which these
terms are hold constant. These predictions are a good representation of the
sample, because all possible values and levels of the non-focal predictors
are considered. It answers the question, "What is the predicted value for
an 'average' observation in \emph{my data}?". Cum grano salis, it refers to
randomly picking a subject of your sample and the result you get on
average. This approach is the one taken by default in the \code{emmeans}
package.
\item \code{"population"}: Non-focal predictors are marginalized over the observations
in the sample, where the sample is replicated multiple times to produce
"counterfactuals" and then takes the average of these predicted values
(aggregated/grouped by the focal terms). It can be considered as
extrapolation to a hypothetical target population. Counterfactual
predictions are useful, insofar as the results can also be transferred to
other contexts (Dickerman and Hernan, 2020). It answers the question, "What
is the predicted response value for the 'average' observation in \emph{the
broader target population}?". It does not only refer to the actual data in
your observed sample, but also "what would be if" we had more data, or if
we had data from a different sample.
}

In other words, the distinction between estimate types resides in whether
the prediction are made for:
\itemize{
\item A specific "individual" from the sample (i.e., a specific combination of
predictor values): this is what is obtained when using \code{\link[=estimate_relation]{estimate_relation()}}
and the other prediction functions.
\item An average individual from the sample: obtained with
\code{estimate_means(..., estimate = "average")}
\item The broader, hypothetical target population: obtained with
\code{estimate_means(..., estimate = "population")}
}}

\item{p_adjust}{The p-values adjustment method for frequentist multiple
comparisons. Can be one of \code{"none"} (default), \code{"hochberg"}, \code{"hommel"},
\code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"tukey"} or \code{"holm"}. See the
p-value adjustment section in the \code{emmeans::test} documentation or
\code{?stats::p.adjust}.}
}
\description{
These functions are convenient wrappers around the \strong{emmeans} and the
\strong{marginaleffects} packages. They are mostly available for developers who want
to leverage a unified API for getting model-based estimates, and regular users
should use the \verb{estimate_*} set of functions.

The \code{get_emmeans()}, \code{get_emcontrasts()} and \code{get_emtrends()} functions are
wrappers around \code{emmeans::emmeans()} and \code{emmeans::emtrends()}.
}
\examples{
\dontshow{if (insight::check_if_installed("emmeans", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Basic usage
model <- lm(Sepal.Width ~ Species, data = iris)
get_emcontrasts(model)

\dontrun{
# Dealing with interactions
model <- lm(Sepal.Width ~ Species * Petal.Width, data = iris)
# By default: selects first factor
get_emcontrasts(model)
# Can also run contrasts between points of numeric
get_emcontrasts(model, contrast = "Petal.Width", length = 3)
# Or both
get_emcontrasts(model, contrast = c("Species", "Petal.Width"), length = 2)
# Or with custom specifications
estimate_contrasts(model, contrast = c("Species", "Petal.Width=c(1, 2)"))
# Or modulate it
get_emcontrasts(model, by = "Petal.Width", length = 4)
}
\dontshow{\}) # examplesIf}
\dontshow{if (require("emmeans", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lm(Sepal.Length ~ Species + Petal.Width, data = iris)

# By default, 'by' is set to "Species"
get_emmeans(model)

\dontrun{
# Overall mean (close to 'mean(iris$Sepal.Length)')
get_emmeans(model, by = NULL)

# One can estimate marginal means at several values of a 'modulate' variable
get_emmeans(model, by = "Petal.Width", length = 3)

# Interactions
model <- lm(Sepal.Width ~ Species * Petal.Length, data = iris)

get_emmeans(model)
get_emmeans(model, by = c("Species", "Petal.Length"), length = 2)
get_emmeans(model, by = c("Species", "Petal.Length = c(1, 3, 5)"), length = 2)
}
\dontshow{\}) # examplesIf}
\dontshow{if (insight::check_if_installed("emmeans", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
model <- lm(Sepal.Width ~ Species * Petal.Length, data = iris)

get_emtrends(model)
get_emtrends(model, by = "Species")
get_emtrends(model, by = "Petal.Length")
get_emtrends(model, by = c("Species", "Petal.Length"))
}

model <- lm(Petal.Length ~ poly(Sepal.Width, 4), data = iris)
get_emtrends(model)
get_emtrends(model, by = "Sepal.Width")
\dontshow{\}) # examplesIf}
\dontshow{if (insight::check_if_installed("marginaleffects", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lm(Sepal.Length ~ Species + Petal.Width, data = iris)

# By default, 'by' is set to "Species"
get_marginalmeans(model)

# Overall mean (close to 'mean(iris$Sepal.Length)')
get_marginalmeans(model, by = NULL)

\dontrun{
# One can estimate marginal means at several values of a 'modulate' variable
get_marginalmeans(model, by = "Petal.Width", length = 3)

# Interactions
model <- lm(Sepal.Width ~ Species * Petal.Length, data = iris)

get_marginalmeans(model)
get_marginalmeans(model, by = c("Species", "Petal.Length"), length = 2)
get_marginalmeans(model, by = c("Species", "Petal.Length = c(1, 3, 5)"), length = 2)
}
\dontshow{\}) # examplesIf}
\dontshow{if (insight::check_if_installed("marginaleffects", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lm(Sepal.Width ~ Species * Petal.Length, data = iris)

get_marginaltrends(model, trend = "Petal.Length", by = "Species")
get_marginaltrends(model, trend = "Petal.Length", by = "Petal.Length")
get_marginaltrends(model, trend = "Petal.Length", by = c("Species", "Petal.Length"))
\dontshow{\}) # examplesIf}
}
