% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_add.R
\name{get_add}
\alias{get_add}
\title{Models That Are Less Restricted}
\usage{
get_add(
  sem_out,
  must_add = NULL,
  must_not_add = NULL,
  remove_constraints = TRUE,
  exclude_error_cov = TRUE,
  df_change = 1,
  model_id = NA,
  keep_correct_df_change = TRUE,
  remove_duplicated = TRUE,
  progress = FALSE
)
}
\arguments{
\item{sem_out}{The original model,
which is the output from an
structural equation modeling
function. Currently support
\link[lavaan:lavaan-class]{lavaan::lavaan} objects only.}

\item{must_add}{A character vector
of parameters, named in
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} style (e.g.,
\code{"y ~ x"}), that must be added.
Default is \code{NULL}.}

\item{must_not_add}{A character
vector of parameters, named in
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} style (e.g.,
\code{"x1 ~~ x1"}), that must not be
added. Default is \code{NULL}.}

\item{remove_constraints}{Whether
equality constraints will be
removed. Default is \code{TRUE}.}

\item{exclude_error_cov}{Exclude
error covariances of indicators.
Default is \code{TRUE}.}

\item{df_change}{How many degrees
of freedom (\emph{df}) away in the list.
All models with \emph{df} change less than
or equal to this number will be
included, taking into account
requirements set by other arguments.
Default is 1.}

\item{model_id}{The identification
number of the starting model.
Default is \code{NA}, no identification
number.}

\item{keep_correct_df_change}{Keep
only models with actual \emph{df} change
equal to expected \emph{df} change.}

\item{remove_duplicated}{If \code{TRUE},
the default, duplicated models are
removed.}

\item{progress}{Whether a progress
bar will be displayed, implemented
by the \code{pbapply} package. Default
is \code{FALSE}.}
}
\value{
An object of the class
\code{partables}, a named list of parameter
tables, each of them to be used by
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or \code{\link[=update]{update()}}
for fitting a model with the added
parameters.
}
\description{
Generate a list of
models with one or more fixed
parameter freed.
}
\details{
It generates a list of models
with one or more fixed parameter
freed (and the degrees of freedom, \emph{df},
increases by one or more). If a
model has equality constraints, models
with one or more of the constraints
between two free parameters
released will also be included.

Graphically, paths or covariances
are "added" to form the list of models.

The models to be included are
identified by
\code{\link[lavaan:modificationIndices]{lavaan::modificationIndices()}}.

The models will be checked by \code{lavaan}
to make sure that the decrease in
model degrees of freedom is of the
expected value.

This function is called by
\code{\link[=model_set]{model_set()}} and usually users do
not need to call it. It is exported
for advanced users.
}
\examples{

library(lavaan)
dat <- dat_path_model
mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"
fit <- sem(mod, dat_path_model, fixed.x = TRUE)
mod_to_add <- get_add(fit)
mod_to_add

}
\seealso{
\code{\link[=print.partables]{print.partables()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
