% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmoezipf.R
\name{dmoezipf}
\alias{dmoezipf}
\title{Density function.}
\usage{
dmoezipf(x, alpha, beta, log = FALSE, show.plot = F)
}
\arguments{
\item{x}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1} ).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0} ).}

\item{log}{Logical; if TRUE, probabilities p are given as log(p).}

\item{show.plot}{Logical; if TRUE shows the plot of the distibution (default = FALSE).}
}
\value{
The probability associated to each value in vector \code{x}.
}
\description{
Density function for the Marshall-Olkin Extended Zipf distribution
with parameters \eqn{\alpha} and \eqn{\beta}.
}
\details{
The probability mass function at a positive integer value \eqn{x} of the MOEZipf distribution with
parameters \eqn{\alpha} and \eqn{\beta} is computed as follows:

\deqn{p(x | \alpha, \beta) = \frac{x^{-\alpha} \beta \zeta(\alpha) }{[\zeta(\alpha) - \bar{\beta} \zeta (\alpha, x)] [\zeta (\alpha) - \bar{\beta} \zeta (\alpha, x + 1)]}, \alpha > 1, \beta > 0, }

where \eqn{\zeta(\alpha)} is the Riemann-zeta function at \eqn{\alpha}, \eqn{\zeta(\alpha, x)}
is the Hurtwitz zeta function with arguments \eqn{\alpha} and x, and \eqn{\bar{\beta} = 1 - \beta}.
}
\examples{
dmoezipf(1:10, 2.5, 1.3)
dmoezipf(1:10, 2.5, 1.3, show.plot = TRUE)
}

