% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_generation.R
\name{generate_reduced_graph}
\alias{generate_reduced_graph}
\title{Generate a reduced iGraph}
\usage{
generate_reduced_graph(
  measurement_data,
  identifiers,
  correlation_method = "spearman",
  reduction_method = "p_value",
  save_correlation_filename = NULL,
  handling_missing_data = "all.obs",
  p_value_adjustment_method = "BH",
  reduction_alpha = 0.05,
  r_squared_cutoff = 0.85,
  cut_vector = seq(0.2, 0.8, by = 0.05),
  print_graph_info = FALSE,
  n_threads = parallel::detectCores() - 1,
  parallel_chunk_size = 10^6
)
}
\arguments{
\item{measurement_data}{Data frame containing raw data (e.g. mRNA expression data, protein
abundance, etc.). Analyzed components (e.g. genes) in rows, samples (e.g. patients) in columns.}

\item{identifiers}{Data frame containing  biological identifiers and the corresponding node ID
created in \link[molnet]{create_unique_layer_node_ids}. The column containing node IDs has to
be named `node_id`.}

\item{correlation_method}{A character string specifying the method to be used for correlation
calculation by \link[WGCNA]{cor}. Can be any of "spearman", "pearson" or "kendall".}

\item{reduction_method}{A character string specifying the method to be used for network
reduction. `p_value` for hard thresholding based on the statistical significance of the
computed correlation. `pickHardThreshold` for a cutoff based on the scale-freeness criterion
(calls `WGCNA::pickHardThreshold`).}

\item{save_correlation_filename}{(optional) Set a name for saving the matrix of correlations.
Will be saved as .rds file.}

\item{handling_missing_data}{A character string specifying the handling of missing data. Use
"all.obs" (default) or "pairwise.complete.obs". Argument is passed to `WGCNA::cor()`.}

\item{p_value_adjustment_method}{String of the correction method applied to p-values. Passed to
\link[stats]{p.adjust}.}

\item{reduction_alpha}{A number indicating the alpha value applied for thresholding.}

\item{r_squared_cutoff}{A number indicating the desired minimum scale free topology fitting
index R^2.}

\item{cut_vector}{A vector of hard threshold cuts for which the scale free topology fit indices
are to be calculated.}

\item{print_graph_info}{A boolean value specifying if a summary of the reduced graph should be
printed.}

\item{n_threads}{Number of threads for parallel computation of p-values during p-value
reduction.}

\item{parallel_chunk_size}{Number of p-values in smallest work unit when computing in parallel
during network reduction with method `p_value`.}
}
\value{
iGraph graph object of the reduced network.
}
\description{
(INTERNAL) A wrapper functions that calls the functions to generate a network from raw data and
 reduce the network by a given method. Graph generation is using
 \code{\link[igraph]{graph.adjacency}} internally.
Methods implemented are \link[molnet]{network_reduction_by_p_value} (reduction by statistical
significance of correlation) and \link[molnet]{network_reduction_by_pickHardThreshold} (using
WGCNA function \link[WGCNA]{pickHardThreshold.fromSimilarity} that finds a suitable cutoff
value to get a scale-free network).
If no method is given, no reduction will be performed. When using the reduction method
`p_value` the user can specify an alpha significance value and a method for p-value adjustment.
 When using the reduction by `pickHardthreshold` a R-Squared Cutoff can be specified and a cut
 vector can be supplied.
The adjacency matrix of correlations is computed using \link[WGCNA]{cor}. The handling of
missing data can be specified. Both the adjacency of correlations and the graph object can be
saved optionally.
}
