% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC_momentuHMM.R
\name{AIC.momentuHMM}
\alias{AIC.momentuHMM}
\title{AIC}
\usage{
\method{AIC}{momentuHMM}(object, ..., k = 2, n = NULL)
}
\arguments{
\item{object}{A \code{momentuHMM} object.}

\item{...}{Optional additional \code{momentuHMM} objects, to compare AICs of the different models.}

\item{k}{Penalty per parameter. Default: 2 ; for classical AIC.}

\item{n}{Optional sample size. If specified, the small sample correction AIC is used (i.e., \code{AICc = AIC + kp(p+1)/(n-p-1)} where p is the number of parameters).}
}
\value{
The AIC of the model(s) provided. If several models are provided, the AICs are output
in ascending order.
}
\description{
Akaike information criterion of momentuHMM model(s).
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m
AIC(m)

}
