% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_crwData.R
\name{plot.crwData}
\alias{plot.crwData}
\title{Plot \code{crwData}}
\usage{
\method{plot}{crwData}(x, animals = NULL, compact = FALSE, ask = TRUE,
  plotEllipse = TRUE, crawlPlot = FALSE, ...)
}
\arguments{
\item{x}{An object \code{crwData} (as returned by \code{\link{crawlWrap}}).}

\item{animals}{Vector of indices or IDs of animals for which information will be plotted.
Default: \code{NULL} ; all animals are plotted.}

\item{compact}{\code{TRUE} for a compact plot (all individuals at once), \code{FALSE} otherwise
(default -- one individual at a time). Ignored unless \code{crwPredictPlot=FALSE}.}

\item{ask}{If \code{TRUE}, the execution pauses between each plot.}

\item{plotEllipse}{If \code{TRUE} (the default) then error ellipses are plotted (if applicable). Ignored unless \code{crwPredictPlot=FALSE}.}

\item{crawlPlot}{Logical indicating whether or not to create individual plots using \code{\link[crawl]{crwPredictPlot}}. See \code{\link[crawl]{crwPredictPlot}} for details.}

\item{...}{Further arguments for passing to \code{\link[crawl]{crwPredictPlot}}}
}
\description{
Plot observed locations, error ellipses (if applicable), predicted locations, and prediction intervals from \code{\link{crwData}} object.
}
\details{
In order for error ellipses to be plotted, the names for the semi-major axis, semi-minor axis, and 
orientation in \code{x$crwPredict} must respectively be \code{error_semimajor_axis}, \code{error_semiminor_axis},     
and \code{error_ellipse_orientation}. 

If the \code{crwData} object was created using data generated by
\code{\link{simData}} or \code{\link{simObsData}}, then the true locations (\code{mux},\code{muy}) are also plotted.
}
\examples{
\dontrun{
# extract simulated obsData from example data
obsData <- miExample$obsData

# extract crwMLE inputs from example data
inits <- miExample$inits # initial state
err.model <- miExample$err.model # error ellipse model

# create crwData object
crwOut <- crawlWrap(obsData=obsData,
         theta=c(4,0),fixPar=c(1,1,NA,NA),
         initial.state=inits,
         err.model=err.model)

plot(crwOut,compact=TRUE,ask=FALSE,plotEllipse=FALSE)
}

}
\seealso{
\code{\link[crawl]{crwPredictPlot}}
}
