% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{calc_posterior}
\alias{calc_posterior}
\title{Function which calculates for k=1, ..., K, Pr(log-HR >= lhr_null | theta.hat.k = lhr_con.k)
i.e. the posterior probability the true OS log-hr exceeds the minimum unacceptable
OS log-HR given the estimate of the log-hr at analysis k equals lhr_con.k (i.e. the estimate
is equal to the stage k 'continuation threshold').}
\usage{
calc_posterior(lhr_con, lhr_null, events)
}
\arguments{
\item{lhr_con}{vector of length K (# number of looks at OS data) containing 'continuation' thresholds on log-HR scale}

\item{lhr_null}{scalar - minumum unacceptable OS log-HR}

\item{events}{vector length K - number of OS events at each look at the data}
}
\value{
vector of length K - continuation thresholds expressed on posterior probability scale
}
\description{
Function which calculates for k=1, ..., K, Pr(log-HR >= lhr_null | theta.hat.k = lhr_con.k)
i.e. the posterior probability the true OS log-hr exceeds the minimum unacceptable
OS log-HR given the estimate of the log-hr at analysis k equals lhr_con.k (i.e. the estimate
is equal to the stage k 'continuation threshold').
}
