% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MonoClust.R
\name{MonoClust}
\alias{MonoClust}
\title{Monothetic Clustering}
\usage{
MonoClust(
  toclust,
  cir.var = NULL,
  variables = NULL,
  distmethod = c("euclidean", "manhattan", "gower"),
  digits = getOption("digits"),
  nclusters = 2L,
  minsplit = 5L,
  minbucket = round(minsplit/3),
  ncores = 1L
)
}
\arguments{
\item{toclust}{Data set as a data frame.}

\item{cir.var}{Index or name of the circular variable in the data set.}

\item{variables}{List of variables selected for clustering procedure. It
could be a vector of variable indexes, or a vector of variable names.}

\item{distmethod}{Distance method to use with the data set. The default value
is the Euclidean distance but Gower will be used if there is circular
variable (\code{cir.var} is specified). Transfer to \code{\link[cluster:daisy]{cluster::daisy()}}.}

\item{digits}{Significant decimal number printed in the output.}

\item{nclusters}{Number of clusters created. Default is 2.}

\item{minsplit}{The minimum number of observations that must exist in a node
in order for a split to be attempted. Default is 5.}

\item{minbucket}{The minimum number of observations in any terminal leaf
node. Default is \code{minsplit/3}.}

\item{ncores}{Number of CPU cores on the current host. If greater than 1,
parallel processing with \code{\link[foreach:foreach]{foreach::foreach()}} is used to distribute cut
search on variables to processes. When set to NULL, all available cores are
used.}
}
\value{
A \code{MonoClust} object. See \code{\link{MonoClust.object}}.
}
\description{
Creates a MonoClust object after partitioning the data set using Monothetic
Clustering.
}
\examples{
# Very simple data set
library(cluster)
data(ruspini)
ruspini4sol <- MonoClust(ruspini, nclusters = 4)
ruspini4sol

# data with circular variable
library(monoClust)
data(wind_sensit_2007)

# Use a small data set
set.seed(12345)
wind_reduced <- wind_sensit_2007[sample.int(nrow(wind_sensit_2007), 10), ]
circular_wind <- MonoClust(wind_reduced, cir.var = 3, nclusters = 2)
circular_wind
}
\references{
\enumerate{
\item Chavent, M. (1998). A monothetic clustering method. Pattern Recognition
Letters, 19(11), 989-996. \doi{10.1016/S0167-8655(98)00087-7}.
\item Tran, T. V. (2019). Monothetic Cluster Analysis with Extensions to
Circular and Functional Data. Montana State University - Bozeman.
}
}
