% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mycph.R
\name{mycph}
\alias{mycph}
\title{Perform coxph of individual expecting variables}
\usage{
mycph(formula, data, digits = 2)
}
\arguments{
\item{formula}{An object of class "formula". Left side of ~ must be a
variable of class Surv and the right side of ~ must have
variables in an additive way.}

\item{data}{A data.frame contains data for analysis.}

\item{digits}{An integer indicating the number of decimal places (round) or
significant digits to be used. Default value is 2.}
}
\value{
a data.frame consist of hazard ratio and 95\% confidence intervals and
        the p values.
}
\description{
Perform coxph of individual expecting variables
}
\examples{
require(survival)
data(colon)
attach(colon)
colon$TS=Surv(time,status==1)
out=mycph(TS~.,data=colon)
out
HRplot(out,type=2,show.CI=TRUE,main="Hazard ratios of all individual variables")
}
