% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mycph.R
\name{HRplot}
\alias{HRplot}
\title{Draw a hazard ratio plot}
\usage{
HRplot(
  out,
  type = 1,
  xlab = "",
  ylab = "",
  show.OR = TRUE,
  show.CI = FALSE,
  sig.level = 1,
  cex = 1.2,
  lwd = 2,
  pch = 18,
  col = NULL,
  ...
)
}
\arguments{
\item{out}{an object of class coxph or a resultant data.frame of mycph function}

\item{type}{an integer indicating the type of plot. Default value is 1}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{show.OR}{a logical vector indicating whether or not show the text
indicating the p value}

\item{show.CI}{a logical vector indicating whether or not show the text
indicating the confidence interval}

\item{sig.level}{a numeric value of upper limit of p value of showing variables}

\item{cex}{A numerical value giving the amount by which plotting OR/HR symbols
should be magnified relative to the default, defaulting 1.2.}

\item{lwd}{The line width, a positive number, defaulting to 2.}

\item{pch}{Either an integer specifying a symbol or a single character
to be used as the default in plotting OR/HR points.}

\item{col}{A specification for the default plotting color.}

\item{...}{arguments to be passed to plot}
}
\value{
This function return NULL invisibly and draw graphs
}
\description{
Draw a hazard ratio plot
}
\examples{
require(survival)
attach(colon)
colon$TS=Surv(time,status==1)
out=mycph(TS~.,data=colon)
out
HRplot(out)
\dontrun{
HRplot(out,type=1,pch=2,col=c("blue","red"))
HRplot(out,type=2,show.CI=TRUE,pch=2,cex=2,main="Hazard ratios of all individual variables")
}

}
