% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapPlotShape.R
\name{morphomapPlotShape}
\alias{morphomapPlotShape}
\title{morphomapPlotShape}
\usage{
morphomapPlotShape(
  Shape,
  dims = 3,
  col1 = "red",
  col2 = "green",
  colc = "orange",
  colr = "violet",
  coll1 = "darkred",
  coll2 = "darkgreen",
  size = 1.5,
  lwd = 0.7,
  colmesh1 = "red",
  colmesh2 = "green",
  alpha = 0.3,
  tri = TRUE,
  outlines = TRUE,
  points = TRUE,
  lines = FALSE,
  centroid = FALSE,
  cent.out = "CCA",
  delta = 0.1,
  vecs = NULL
)
}
\arguments{
\item{Shape}{list: output from morphomapShape function}

\item{dims}{numeric:  2 = bi-dimensional cross sections, 3 = three-dimensional cross sections}

\item{col1}{color of the external outline}

\item{col2}{color of the internal outline}

\item{colc}{color of the centroid of the cross section}

\item{colr}{color of the radii}

\item{coll1}{color of the lines on the enternal outline}

\item{coll2}{color of the lines on the internal outline}

\item{size}{numeric: points and spheres size}

\item{lwd}{numeric: line width in pixels}

\item{colmesh1}{color of the periosteal mesh}

\item{colmesh2}{color of the endosteal mesh}

\item{alpha}{numeric: alpha value between 0(fully transparent) and 1 (opaque)}

\item{tri}{logical: if TRUE the semilandmarks configuration is triangulated}

\item{outlines}{logical: if TRUE the 2D and 3D outlines are plotted}

\item{points}{logical: if TRUE points (2D) and spheres (3D) are plotted}

\item{lines}{logical: if TRUE 2D and 3D lines are plotted}

\item{centroid}{logical: if TRUE 2D and 3D centroids are plotted}

\item{cent.out}{how to define the center of each section. The method allowed are "CCA" (center of cortical area), "E" (barycenter of the external outline) and "I" (barycenter of the internal outline)}

\item{delta}{pixel size used to calculate the CCA}

\item{vecs}{numeric: which sections will be plotted. If dims is set on 2 only the first element of the vector vecs is considered}
}
\description{
Visualize 2D and 3D cross sections
}
\examples{
\dontrun{
#morphomap on a human femur bone
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
inn.sur=endMesh,num.sect=61,mech.len = mech_length, start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,21,sects_vector=NULL,cent.out="CCA",
delta=0.1, side="left")
#Plot the object morphomapShape in three dimensions
morphomapPlotShape(shapeSections,dims=3, size=0.5)
#Plot a 2D cross-section 
morphomapPlotShape(shapeSections,dims=2,lines=TRUE,vecs=31)
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
