% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.reproFitTT.R
\name{summary.reproFitTT}
\alias{summary.reproFitTT}
\title{Summary for reproFitTT objects}
\usage{
\method{summary}{reproFitTT}(object, quiet = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{reproFitTT}}

\item{quiet}{when \code{FALSE}, prints summary on standard output}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
The function returns a list with the following fields:
\item{Qpriors}{quantiles for the model's prior}
\item{Qposteriors}{quantiles for the model's posteriors}
\item{QECx}{quantiles for ECx values}
}
\description{
The summary shows the quantiles of priors and posteriors on parameters
and the quantiles of estimated ECx.
}
\examples{
# (1) Load the data
data(cadmium1)

# (2) Create a reproData object
cadmium1 <- reproData(cadmium1)

\dontrun{
# (3) Run the reproFitTT function with the log-logistic
# model
out <- reproFitTT(dat, ecx = c(5, 10, 15, 20, 30, 50, 80),
quiet = TRUE)

# (4) summarize the reproFitTT object
summary(out)
}
}
\seealso{
reproFitTT
}
\keyword{summary}

