% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.survFitTT.R
\name{summary.survFitTT}
\alias{summary.survFitTT}
\title{Summary for survFitTT objects}
\usage{
\method{summary}{survFitTT}(object, quiet = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{survFitTT}}

\item{quiet}{when \code{FALSE}, prints summary on standard output}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
The function returns a list with the following fields:
\item{Qpriors}{quantiles for the model's prior}
\item{Qposteriors}{quantiles for the model's posteriors}
\item{QLCx}{quantiles for LCx values}
}
\description{
The summary shows the quantiles of priors and posteriors on parameters
and the quantiles of estimated LCx.
}
\examples{
# (1) Load the data
data(cadmium1)

# (2) Create a survData object
cadmium1 <- survData(cadmium1)

\dontrun{
# (3) Run the survFitTT function with the log-logistic
# binomial model
out <- survFitTT(dat, lcx = c(5, 10, 15, 20, 30, 50, 80),
                 quiet = TRUE)

# (4) summarize the survFitTT object
summary(out)
}
}
\seealso{
survFitTT
}
\keyword{summary}

