% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_simulation.R
\name{pop.sim.gomp}
\alias{pop.sim.gomp}
\title{Simulation of a population of adults with Gompertz distribution}
\usage{
pop.sim.gomp(n, b = NULL, M = NULL, start_age = 15, max_age = 100)
}
\arguments{
\item{n}{number of individuals to be simulated.}

\item{b}{numeric, optional. Gompertz parameter controlling the
level of mortality.}

\item{M}{numeric, optional. Modal age M.}

\item{start_age}{numeric. Start age, default: 15 years.}

\item{max_age}{numeric. Maximal age, to avoid unlikely centenaries,
default: 100 years.}
}
\value{
A list of two data.frames with the following items:

First data.frame
\itemize{
  \item \bold{N}:  Number of individuals.
  \item \bold{b}:  Gompertz parameter controlling mortality.
  \item \bold{M}:  Modal age.
  \item \bold{a}:  Gompertz parameter controlling hazard of the
  youngest age group.
 }

Second data.frame
\itemize{
  \item \bold{ind}:  ID of individuals.
  \item \bold{age}:  Simulated absolute age.
 }
}
\description{
In many instances, it is useful to calculate with a population with
known parameters. To generate a population with realistic
characteristics is less obvious than it seems. We operate here
with the Gompertz distribution which provides a reasonable
approximation of human mortality for \bold{adult} mortality, that is
for the ages >= 15 years. The user has to specify
either the parameter b or the modal age M. The modal age M is
particular useful as it provides an intuitive understanding of
the resulting age distribution. In both instances, the second
parameter a is generated by the regression formula found by
\emph{Sasaki and Kondo 2016}. If neither is given, a population
with random parameters realistic for pre-modern times is generated.
}
\examples{

pop_sim <- pop.sim.gomp(n = 10000, M = 35)
pop_sim <- pop.sim.gomp(n = 10000, b = 0.03)
pop_sim <- pop.sim.gomp(n = 10000)
}
\references{
\insertRef{sasaki_kondo_2016}{mortAAR}
}
