% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ediff.R
\name{ediff}
\alias{ediff}
\title{Lagged Differences with equal length}
\usage{
ediff(x, lag = 1, differences = 1, pad = c("head", "tail", "symmetric"),
  pad.value = NA, frontPad, ...)
}
\arguments{
\item{x}{a numeric vector or a matrix containing the values to be differenced}

\item{lag}{an integer indicating which lag to use}

\item{differences}{an integer indicating the order of the difference}

\item{pad}{one of \code{"head"}, \code{"tail"}, or \code{"symmetric"}.
indicating where the \code{pad.value} padding should be added to the result.}

\item{pad.value}{the value to be used for padding.}

\item{frontPad}{logical indicating whether padding is on the front (head) or
back (tail) end. This exists for backward compatibility. New code should use
\code{pad} instaed.}

\item{\dots}{further arguments to be passed to or from methods}
}
\description{
Often when creating lagged differences, it is awkward that the differences
vector is shorter than the original.  \code{ediff} pads with \code{pad.value} to
make its output the same length as the input.
}
\examples{
ediff(1:10)
ediff(1:10, pad.value = 0)
ediff(1:10, 2)
ediff(1:10, 2, 2)
x <- cumsum(cumsum(1:10))
ediff(x, lag = 2)
ediff(x, differences = 2)
ediff(x, differences = 2, pad="symmetric")
ediff(.leap.seconds)
if (require(mosaicData)) {
Men <- subset(SwimRecords, sex=="M")
Men <- mutate(Men, change=ediff(time), interval=ediff(year))
head(Men) 
}
}
\seealso{
\code{\link[=diff]{diff()}} since
\code{ediff} is a thin wrapper around \code{\link[=diff]{diff()}}.
}
