% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen.R
\name{create.linear.data}
\alias{create.linear.data}
\title{Create Linear Model Data}
\usage{
create.linear.data(n, p, q = exp(-1), beta0 = 1, rho = 0, permute = TRUE)
}
\arguments{
\item{n}{\verb{[integer(1)]} number of rows to generate.}

\item{p}{\verb{[integer(1)]} number of columns to generate.}

\item{q}{\verb{[numeric(1)]} attenuation factor for beta coefficients.}

\item{beta0}{\verb{[numeric(1)]} size of first coefficient.}

\item{rho}{\verb{[numeric(1)]} parameter for correlation matrix.}

\item{permute}{\verb{[logical(1)]} whether to permute columns of \code{X} and coefficient
vector (\code{beta}).}
}
\value{
\verb{list(X=[Matrix], Y=[vector], beta = [vector], orig.features = logical)}
}
\description{
Create linear model data \code{Y = X * beta + epsilon} with
X as a \code{n * p} matrix of multivariate normal distributed
rows with covariance matrix\preformatted{1     rho rho^2 rho^3 ... rho^p
rho     1 rho   rho^2 ... rho^(p-1)
rho^2 rho   1   rho ...   rho^(p-2)
...
rho^p ...
}

\code{epsilon} is standard normally distributed and
\code{beta[i] = beta0 * q ^ (i - 1)} for \verb{i = 1,..., p}.

If \code{permute == TRUE}, columns of \code{X} as well as \code{beta} are permuted before
the linear model equation is evaluated to generate \code{Y}. These permuted
values are also the ones returned in the result.

\verb{$orig.features} are the features with \code{beta > 1 / sqrt(n)}.
}
\seealso{
Other Artificial Datasets: 
\code{\link{clonetask}()},
\code{\link{create.hypersphere.data}()},
\code{\link{create.linear.toy.data}()},
\code{\link{create.regr.task}()},
\code{\link{task.add.permuted.cols}()},
\code{\link{task.add.random.cols}()}
}
\concept{Artificial Datasets}
