% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.descendents.R
\name{node.descendents}
\alias{node.descendents}
\title{Identify nodes and tips descended from a node}
\usage{
node.descendents(x, phy, tip.labels = FALSE)
}
\arguments{
\item{x}{A positive integer}

\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{tip.labels}{Logical - output tip.labels?}
}
\value{
Returns a vector of node and tip ids descended from the tip(s) "x". If tip.labels=TRUE then returns a list of node ids and tip labels.
}
\description{
Obtains a vector of the tips and nodes subtending from a node in a phylogeny.
}
\details{
This function is stolen from the clade.members function in the CAIC package but returns both node and tip id's.
}
\note{
\code{as.rateMatrix} calls the CAIC function \code{vcv.array} multiple times and this can be slow for large phylogenies (though faster than using the \pkg{ape} equivalent \code{vcv.phylo}).
}
\author{
Gavin Thomas, David Orme
}
