% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformPhylo.MCMC.R
\name{transformPhylo.MCMC}
\alias{transformPhylo.MCMC}
\title{Bayesian MCMC for models of trait evolution}
\usage{
transformPhylo.MCMC(y, phy, model, mcmc.iteration = 1000,
  burn.in = 0.1, hiddenSpeciation = FALSE, full.phy = NULL,
  lowerBound = NULL, upperBound = NULL, useMean = FALSE,
  random.start = TRUE, meserr = NULL, covPIC = TRUE,
  lambdaEst = FALSE, nodeIDs = NULL, branchLabels = NULL,
  acdcScalar = FALSE, sample.every = 10)
}
\arguments{
\item{y}{A matrix of trait values.}

\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{model}{The model of trait evolution (see details).}

\item{mcmc.iteration}{Integer - the number of generations for which to run the MCMC chain}

\item{burn.in}{The proportion of the chain (as given by mcmc.iteration) which to discard as 'burn-in'}

\item{hiddenSpeciation}{Logical. If TRUE the psi model will include nodes that are on the 'full.phy' but not the tree pruned of trait data}

\item{full.phy}{The full phylogeny containing the species that do not contain trait data so are not included in 'phy'}

\item{lowerBound}{Minimum value for parameter estimates}

\item{upperBound}{Maximum value for parameter estimates}

\item{useMean}{Logical. Use the branch-based estimates of extinction of mean (TRUE, default) for the "psi" and "multispi" models only applicable if "hiddenSpeciation" = TRUE}

\item{random.start}{Use a random starting value for the MCMC run (TRUE), or use the environment set.seed() value}

\item{meserr}{A vector (or matrix) of measurement error for each tip. This is only applicable to univariate analyses}

\item{covPIC}{Logical. For multivariate analyses, allow for co-variance between traits rates (TRUE) or no covariance in trait rates (FALSE). If FALSE, only the trait variances not co-variances are used.}

\item{lambdaEst}{Logical.  Estimate lambda alongside parameter estimates to reduce data noise. Only applicable for models "kappa", "delta", "OU", "psi", "multispi", and "ACDC". Default=FALSE.}

\item{nodeIDs}{Integer - ancestral nodes of clades applicable to rate heterogenous and nested models of evolution (see details)}

\item{branchLabels}{Branches on which different psi parameters are estimated in the "multipsi" model}

\item{acdcScalar}{Logical.  For nested EB rate model, simultaneously estimated a rate scalar alongside EB model. Default=FALSE.}

\item{sample.every}{Number specifying the every nth that is sampled in the MCMC chain (default = 1).}
}
\value{
median The median estimate of the posterior for the parameter

95.HPD The 95 percent Highest Posterior Density for the parameter

ESS Effective Sample Size for the posterior

acceptance.rate The ratio for which new proposals were accepted during the MCMC chain

mcmc.chain Full MCMC chain containing all iterations (including burn-in)
}
\description{
Fits Bayesian models for various models of continuous character evolution using a Metropolis-Hastings Markov Chain Monte Carlo (MCMC) approach
}
\details{
The method estimates posterior probabilities using a Metropolis-Hastings MCMC approach that places a prior bounded uniform distribution on all parameters with an independence sampler. These prior distributions can be altered by changing the upperBound and lowerBound arguments. The MCMC model will estimate the posterior probability for the following models:
\itemize{
\item {model="kappa"} {fits Pagel's kappa by raising all branch lengths to the power kappa. As kappa approaches zero, trait change becomes focused at branching events. For complete phylogenies, if kappa approaches zero this infers speciational trait change. Default bounds from ~0 - 1.}
\item {model="lambda"} {fits Pagel's lambda to estimate phylogenetic signal by multiplying all internal branches of the tree by lambda, leaving tip branches as their original length (root to tip distances are unchanged). Default bounds from ~0 - 1.}
\item {model="delta"} {fits Pagel's delta by raising all node depths to the power delta. If delta <1, trait evolution is concentrated early in the tree whereas if delta >1 trait evolution is concentrated towards the tips. Values of delta above one can be difficult to fit reliably. Default bounds from ~0 - 5.}
\item {model="OU"} {fits an Ornstein-Uhlenbeck model - a random walk with a central tendency proportional to alpha. High values of alpha can be interpreted as evidence of evolutionary constraints, stabilising selection or weak phylogenetic signal. It is often difficult to distinguish among these possibilities. Default bounds from ~0 - 10.}
\item {model="psi"} {fits a acceleration-deacceleration model to assess to the relative contributions of speciation and gradual evolution to a trait's evolutionary rate (Ingram 2010).}
\item {model="ACDC"} {fits a model to in which rates can exponentially increased or decrease through time (Blomberg et al. 2003). If the upper bound is < 0, the model is equivalent to the 'Early Burst' model of Harmon et al. 2010. Default rate parameter bounds from ln(1e-10) ~ ln(20) divided by the root age.}
}
}
\examples{
data(anolis.tree)
data(anolis.data)
attach(anolis.data)
male.length <- matrix(Male_SVL, dimnames=list(rownames(anolis.data)))
sortedData <- sortTraitData(anolis.tree, male.length)
phy <- sortedData$phy
male.length <- sortedData$trait
phy.clade <- extract.clade(phy, 182)
male.length.clade <- as.matrix(male.length[match(phy.clade$tip.label, rownames(male.length)),])
## please note, this model will be need to run for longer to achieve convergence
lambda.mcmc <- transformPhylo.MCMC(y=male.length.clade, phy=phy.clade, 
model="lambda", mcmc.iteration=100, burn.in=0.1)
}
\seealso{
\code{\link{transformPhylo.ML}}, \code{\link{transformPhylo.ll}}, \code{\link{transformPhylo}}
}
\author{
Mark Puttick, Gavin Thomas
}
