% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantileeffect.R
\name{mt_qeffect}
\alias{mt_qeffect}
\title{Create quantile-effect plot}
\usage{
mt_qeffect(data, compare, use = "measures", measure = "MAD",
  direction = "upward", n_steps = 100, return_data = FALSE, ...)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{compare}{either a vector, the label of a variable in , or a mousetrap object.}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{measure}{a character value specifying the variable used to calculate the
effect between}

\item{direction}{a character value.}

\item{n_steps}{an integer.}

\item{return_data}{boolean.}

\item{...}{additional arguments passed on to \link[graphics]{points}.}
}
\value{
Nothing, when image is plotted using an external device. Otherwise an
  object of class \code{mt_object_raw} containing in a matrix format the
  image's pixel information.
}
\description{
Function in beta and currently only for internal purposes.
}
\examples{
# Plot regular heatmap
#SpiveyEtAl2005 = mt_import_long(SpiveyEtAl2005_raw,'x','y',NULL,'t',
#mt_id_label = c('ptp','trial'))
#heatmap = mt_heatmap_raw(SpiveyEtAl2005,xres = 2000)
#mt_heatmap(heatmap,file = NULL)

# compute measures
#SpiveyEtAl2005 = mt_measures(SpiveyEtAl2005)

# Plot heatmap using velocity
#mt_heatmap(SpiveyEtAl2005)

}
\author{
Dirk U. Wulff (\email{dirk.wulff@gmail.com})
}
