% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezier.R
\name{bezier}
\alias{bezier}
\title{Create Bezier-curves using the Bernstein approximation.}
\usage{
bezier(x = c(0, 1, -1), y = c(0, 1.5, 1.5), w = 1, resol = 100)
}
\arguments{
\item{x}{a numeric vector giving the x-coordinates of exactly three
Bezier-points. Defaults to c(0,1,-1) matching the 'mt' format in
\link{mt_align}.}

\item{y}{a numeric vector giving the x-coordinates of exactly three
Bezier-points. Defaults to c(0,1.5,1.5) matching the 'mt' format in
\link{mt_align}.}

\item{w}{a numeric value or vector specifying one or several Bezier curves,
with \code{w} governing the pull towards the middle point. Each entry in
\code{w} creates one Bezier-curve.}

\item{resol}{a numeric value specifying the spatial resolution of the bezier
curves. For example, \code{resol = 100} creates bezier curves comprised of
100 points each.}
}
\value{
A trajectory array containing the bezier curves.
}
\description{
\code{bezier} creates 3-point Bezier-curves using the
Bernstein approximation to simulate continuous competition
in mouse- and hand-trajectories.
}
\examples{
# Generate range of Bezier-curves
bezier_curves <- bezier(w=seq(0,10,.1))

# Plot curves
mt_plot(bezier_curves)
   
}
\author{
Dirk U. Wulff
}
