% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_formats.R
\name{suggest_formats}
\alias{suggest_formats}
\title{Suggest known file formats}
\usage{
suggest_formats(
  suggested = c("gif", "mov", "mp4", "flv", "avi", "mpeg", "3gp", "ogg")
)
}
\arguments{
\item{suggested}{character, a vector of suggested file formats which are checked to be known by the available renderers on the running system. By default, these are \code{c("gif", "mov", "mp4", "flv", "avi", "mpeg", "3gp", "ogg")}.}
}
\value{
A subset of \code{suggested}, containing only those file formats which are known by the renderers on the running system.
}
\description{
This function returns a selection of suggested file formats that can be used with \code{out_file} of \code{\link{animate_frames}} on your system.
}
\examples{
# find out which formats are available
suggest_formats()

# check for a particular format not listed in "suggested" that you want to use, e.g. m4v
suggest_formats("m4v")
# if "m4v" is returned, you can use this format with animate_frames

}
\seealso{
\code{\link{animate_frames}}
}
