% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listCodingErrors.R
\name{listCodingErrors}
\alias{listCodingErrors}
\title{Generate a list of encoding errors}
\usage{
listCodingErrors(founders, finals, hetData)
}
\arguments{
\item{founders}{Genetic data for the founding lines of the population}

\item{finals}{Genetic data for the final lines of the population}

\item{hetData}{Data about the encoding of marker heterozygotes}
}
\value{
List with the following entries:
	\describe{
		\item{finals}{Markers with an invalid observed value.}
	\item{null}{Markers with a missing value for a founding line, for which the are observations for at least one genetic line.}
		\item{missingHetData}{Markers for which a homozygote did not have an encoding.}
	\item{invalidHetData}{Markers for which the heterozygote encoding data was invalid.}
}
}
\description{
Generate a list of encoding errors from genetic data
}
\details{
Given genetic data matrices for the founding lines and the final lines of a population, and information about the encoding of marker heterozygotes, generate a list of errors. 
These errors include observed values which don't correspond to a known combination of marker alleles, missing values in the genetic data for the founding lines, etc. 

The results of this function allow human-readable lists of errors to be generated, or errors to be automatically fixed (if the errors are sufficiently simple).
}
